/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.juicer.JuicerRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class JuicerRecipeCategory
implements IRecipeCategory<JuicerRecipe> {
    public static final RecipeType<JuicerRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"juicer", JuicerRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public JuicerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei.png"), 0, 181, 64, 36);
        this.localizedName = Component.translatable((String)"extradelight.jei.juicer");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.JUICER.get()));
    }

    public RecipeType<JuicerRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JuicerRecipe recipe, IFocusGroup focuses) {
        Ingredient input = recipe.getInput();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 10).addIngredients(input);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 - 8, 1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(recipe.getFluid()))).setFluidRenderer((long)recipe.getFluid().getAmount(), false, 16, 16);
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 - 8, 19).addItemStack(recipe.getResultItem(null));
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, this.getWidth() / 2 + 15, 1);
        slot.addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{BottleFluidRegistry.getBottleFromFluidWithoutSize(recipe.getFluid().getFluid()), new ItemStack((ItemLike)recipe.getFluid().getFluid().getBucket())}));
    }

    public void draw(JuicerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        guiGraphics.drawString(fontRenderer, recipe.getChance() + "%", this.getWidth() / 2 + 14, 24, 0xFFFFFF);
        RenderSystem.disableBlend();
    }
}

