/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.workstations.evaporator.recipes.EvaporatorRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EvaporatorRecipeCategory
implements IRecipeCategory<EvaporatorRecipe> {
    public static final RecipeType<EvaporatorRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"evaporator", EvaporatorRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public EvaporatorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei3.png"), 0, 183, 84, 73);
        this.localizedName = Component.translatable((String)"extradelight.jei.evaporator");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.EVAPORATOR.get()));
    }

    public RecipeType<EvaporatorRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EvaporatorRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - 49, 1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(recipe.getFluid().getFluids()))).setFluidRenderer(1000L, false, 16, 71);
        builder.addSlot(RecipeIngredientRole.CATALYST, 67, 30).addIngredients(Ingredient.of((TagKey)ItemTags.SHOVELS));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 44, 30).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.getResultItem(null)}));
    }

    public void draw(EvaporatorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.evaporator.extra"), 30, 50, 0xFFFFFF);
        guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.evaporator.view"), 27, 4, 0xFFFFFF);
        guiGraphics.drawString(fontRenderer, (Component)Component.translatable((String)"extradelight.jei.info.evaporator.sky"), 44, 14, 0xFFFFFF);
        RenderSystem.disableBlend();
    }

    public int getWidth() {
        return 101;
    }
}

