/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidStackWidget
extends AbstractWidget {
    private final Supplier<FluidTank> getFluid;

    public FluidStackWidget(int x, int y, int width, int height, Supplier<FluidTank> getFluid) {
        super(x, y, width, height, (Component)Component.empty());
        this.getFluid = getFluid;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        FluidTank fluidTank = this.getFluid.get();
        if (!fluidTank.getFluid().isEmpty()) {
            AbstractTexture texture;
            FluidStack fluidStack = fluidTank.getFluid();
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation still = props.getStillTexture(fluidStack);
            if (still != null && (texture = minecraft.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.getSprite(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)color) / 255.0f), (float)((float)FastColor.ARGB32.green((int)color) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)((float)FastColor.ARGB32.alpha((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int stored = fluidTank.getFluidAmount();
                float capacity = fluidTank.getCapacity();
                float filledVolume = (float)stored / capacity;
                int renderableHeight = (int)(filledVolume * (float)this.height);
                int atlasWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
                int atlasHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, (float)(this.height - 16), 0.0f);
                int i = 0;
                while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
                    int drawingHeight = Math.min(16, renderableHeight - 16 * i);
                    int notDrawingHeight = 16 - drawingHeight;
                    guiGraphics.blit(TextureAtlas.LOCATION_BLOCKS, this.getX(), this.getY() + notDrawingHeight, 0, sprite.getU0() * (float)atlasWidth, sprite.getV0() * (float)atlasHeight + (float)notDrawingHeight, this.width, drawingHeight, atlasWidth, atlasHeight);
                    guiGraphics.pose().translate(0.0f, -16.0f, 0.0f);
                    ++i;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.pose().popPose();
            }
            this.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        RenderSystem.disableDepthTest();
    }

    public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.renderTooltip(minecraft.font, Arrays.asList(this.getFluid.get().getFluid().getDisplayName().getVisualOrderText(), Component.literal((String)(this.getFluid.get().getFluidAmount() + "mB")).getVisualOrderText()), mouseX, mouseY);
        }
    }

    protected boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

