/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.events;

import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.ExtraDelightWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="extradelight")
public class CornMazeEvents {
    @SubscribeEvent
    public static void onDeath(LivingIncomingDamageEvent event) {
        ServerPlayer p;
        LivingEntity livingEntity;
        if (event.getEntity().level().dimension() == ExtraDelightWorldGen.CORNFIELD && (livingEntity = event.getEntity()) instanceof ServerPlayer && (p = (ServerPlayer)livingEntity).getHealth() <= event.getAmount()) {
            p.playSound(SoundEvents.WITCH_CELEBRATE, 1.0f, 1.0f);
            event.setCanceled(true);
            p.getInventory().items.stream().filter(i -> i.is(ExtraDelightTags.CORN_CONFISCATE)).forEach(i -> p.getInventory().removeItem(i));
            BlockPos pos = p.getRespawnPosition();
            if (pos == null) {
                pos = p.server.getLevel(Level.OVERWORLD).getSharedSpawnPos();
            }
            p.teleportTo(p.server.getLevel(p.getRespawnDimension()), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0f, 0.0f);
            p.heal(p.getMaxHealth());
            p.sendSystemMessage((Component)Component.translatable((String)"extradelight.corn_dimension.death"));
        }
    }

    @SubscribeEvent
    public static void stopDimensionDestruction(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().isCreative() && event.getPlayer().level().dimension() == ExtraDelightWorldGen.CORNFIELD) {
            event.getPlayer().hurt(event.getPlayer().damageSources().magic(), 1.0f);
            event.getPlayer().makeSound(SoundEvents.WITCH_CELEBRATE);
            event.setCanceled(true);
        }
    }
}

