/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.displays.wreath;

import com.lance5057.extradelight.displays.wreath.WreathBlock;
import com.lance5057.extradelight.displays.wreath.WreathEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Quaternionf;

public class WreathRenderer
implements BlockEntityRenderer<WreathEntity> {
    public WreathRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(WreathEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (!pBlockEntity.hasLevel()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandler r = pBlockEntity.getItemHandler();
        Direction dir = (Direction)pBlockEntity.getBlockState().getValue((Property)WreathBlock.FACING);
        pPoseStack.pushPose();
        float xoff = 0.0f;
        float yoff = 0.0f;
        float zoff = 0.0f;
        for (int i = 0; i < pBlockEntity.getNumSlots(); ++i) {
            ItemStack item = r.getStackInSlot(i);
            if (item.isEmpty()) continue;
            BakedModel bakedmodel = itemRenderer.getModel(item, pBlockEntity.getLevel(), null, 0);
            pPoseStack.pushPose();
            pPoseStack.translate(0.5f, 0.0f, 0.5f);
            pPoseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -dir.toYRot()));
            pPoseStack.translate(-0.5f, 0.0f, -0.5f);
            pPoseStack.translate(0.5f, 0.5f, 0.15f);
            if (i % 2 == 0) {
                pPoseStack.translate(0.0f, 0.0f, 0.01f);
            }
            pPoseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, (float)(i * 45)));
            float uniscale = 0.5f;
            pPoseStack.translate(0.0f, 0.35f, 0.05f);
            pPoseStack.scale(uniscale, uniscale, uniscale);
            pPoseStack.mulPose(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, (float)(i * -45)));
            itemRenderer.render(item, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
            pPoseStack.popPose();
        }
        pPoseStack.popPose();
    }

    public boolean shouldRenderOffScreen(WreathEntity pBlockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 64;
    }

    public boolean shouldRender(WreathEntity pBlockEntity, Vec3 pCameraPos) {
        return true;
    }
}

