/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.displays.fruitbowl;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.util.BlockEntityUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FruitBowlBlockEntity
extends BlockEntity {
    public static final String TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandler> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 9;

    public FruitBowlBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ExtraDelightBlockEntities.FRUIT_BOWL.get(), pPos, pBlockState);
    }

    public int getNumSlots() {
        return 9;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                FruitBowlBlockEntity.this.requestModelDataUpdate();
                FruitBowlBlockEntity.this.setChanged();
                if (FruitBowlBlockEntity.this.getLevel() != null) {
                    FruitBowlBlockEntity.this.getLevel().sendBlockUpdated(FruitBowlBlockEntity.this.worldPosition, FruitBowlBlockEntity.this.getBlockState(), FruitBowlBlockEntity.this.getBlockState(), 3);
                }
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public void insertItem(ItemStack stack) {
        BlockEntityUtils.Inventory.insertItem((IItemHandler)this.items, stack, 9);
        this.updateInventory();
    }

    public void extractItem(Player p) {
        BlockEntityUtils.Inventory.extractItem(p, (IItemHandler)this.items, 9);
        this.updateInventory();
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public IItemHandler getItemHandler() {
        return (IItemHandler)this.itemHandler.get();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(TAG));
        }
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(TAG, (Tag)this.items.serializeNBT(registries));
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }
}

