/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.recipe.ToolOnBlockRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class ToolOnBlockBuilder
implements RecipeBuilder {
    private final BlockItem in;
    private final Ingredient tool;
    private final BlockItem out;
    @Nullable
    private String group;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private ToolOnBlockBuilder(BlockItem pResult, BlockItem block, Ingredient pIngredient) {
        this.in = pResult;
        this.tool = pIngredient;
        this.out = block;
    }

    public static ToolOnBlockBuilder make(Item pResult, Ingredient pIngredient, Item block) {
        if (pResult instanceof BlockItem) {
            BlockItem b1 = (BlockItem)pResult;
            if (block instanceof BlockItem) {
                BlockItem b2 = (BlockItem)block;
                return new ToolOnBlockBuilder(b1, b2, pIngredient);
            }
            ExtraDelight.logger.error("ToolOnBlockRecipe Invalid! " + block.toString() + " is not a BlockItem!");
            return null;
        }
        ExtraDelight.logger.error("ToolOnBlockRecipe Invalid! " + pResult.toString() + " is not a BlockItem!");
        return null;
    }

    public ToolOnBlockBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public ToolOnBlockBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        return this.in;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("toolonblock/");
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        ToolOnBlockRecipe recipe = new ToolOnBlockRecipe(this.in, this.tool, this.out);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/toolonblock/")));
    }
}

