/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.workstations.juicer.JuicerRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;

public class JuicerRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final Ingredient ingredient;
    private final FluidStack fluid;
    private final int chance;
    @Nullable
    private String group;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private JuicerRecipeBuilder(ItemStack pResult, Ingredient pIngredient, FluidStack fluidOut, int chance) {
        this.result = pResult;
        this.ingredient = pIngredient;
        this.fluid = fluidOut;
        this.chance = chance;
    }

    public static JuicerRecipeBuilder squeeze(Ingredient pIngredient, ItemStack pResult, FluidStack fluidOut, int chance) {
        return new JuicerRecipeBuilder(pResult, pIngredient, fluidOut, chance);
    }

    public JuicerRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public JuicerRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        if (this.result != null) {
            return this.result.getItem();
        }
        return Items.AIR;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("juicer/");
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        JuicerRecipe recipe = new JuicerRecipe("", this.ingredient, this.result, this.chance, this.fluid);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/juicer/")));
    }
}

