/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.workstations.dryingrack.DryingRackRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class DryingRackRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    @Nullable
    private String group;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private DryingRackRecipeBuilder(ItemStack pResult, Ingredient pIngredient, float pExperience, int pCookingTime) {
        this.result = pResult;
        this.ingredient = pIngredient;
        this.experience = pExperience;
        this.cookingTime = pCookingTime;
    }

    public static DryingRackRecipeBuilder drying(Ingredient pIngredient, ItemStack pResult, float pExperience, int pCookingTime) {
        return new DryingRackRecipeBuilder(pResult, pIngredient, pExperience, pCookingTime);
    }

    public DryingRackRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public DryingRackRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("drying/");
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        DryingRackRecipe recipe = new DryingRackRecipe("", this.ingredient, this.result, this.experience, this.cookingTime);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/drying/")));
    }
}

