/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.modules.Fermentation;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.registry.ModItems;

public class MiscLootTables
implements LootTableSubProvider {
    protected final HolderLookup.Provider registries;
    public static final ResourceKey<LootTable> SHUCKED_CORN = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"misc/shucked_corn"));
    public static final ResourceKey<LootTable> CORN_TOP = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"misc/corn_top"));
    public static final ResourceKey<LootTable> CINNAMON_LOG = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"misc/cinnamon_log"));
    public static final ResourceKey<LootTable> SOYBEANS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"misc/soybeans"));
    public static final ResourceKey<LootTable> EVAPORATOR_LAVA_TEST = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"evaporator/lava_test"));
    public static final ResourceKey<LootTable> EVAPORATOR_WATER = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"evaporator/water"));

    protected MiscLootTables(HolderLookup.Provider provider) {
        this.registries = provider;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> t) {
        t.accept(SHUCKED_CORN, LootTable.lootTable().withPool(MiscLootTables.createPoolWithItem((Item)ExtraDelightItems.CORN_HUSK.get(), 2, 3)).withPool(MiscLootTables.createPoolWithItem((Item)ExtraDelightItems.CORN_SILK.get(), 1, 2)).withPool(MiscLootTables.createPoolWithItem((Item)ExtraDelightItems.CORN_ON_COB.get(), 1)));
        t.accept(SOYBEANS, LootTable.lootTable().withPool(MiscLootTables.createPoolWithItem((Item)Fermentation.SOYBEANS.get(), 3)));
        t.accept(CINNAMON_LOG, LootTable.lootTable().withPool(MiscLootTables.createPoolWithItem((Item)ExtraDelightItems.CINNAMON_BARK.get(), 1, 4)).withPool(MiscLootTables.createPoolWithItem((Item)ModItems.TREE_BARK.get(), 0, 2)));
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.BIOME);
        t.accept(EVAPORATOR_LAVA_TEST, LootTable.lootTable().withPool(MiscLootTables.createPoolWithItem(Items.COBBLESTONE, 1, 5)).withPool(MiscLootTables.createPoolWithItem(Items.STONE, 1, 4)));
        t.accept(EVAPORATOR_WATER, LootTable.lootTable().withPool(MiscLootTables.createPoolWithItem((Item)Fermentation.SALT.get(), 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).withPool(LootPool.lootPool().name("extras").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROTTEN_FLESH).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_BOOTS).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.0f, (float)0.05f))).setWeight(1))).withPool(LootPool.lootPool().name("ocean_river").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SALMON).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)Fermentation.SALT.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GRAVEL).setWeight(5)).setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{registrylookup.getOrThrow(Biomes.RIVER), registrylookup.getOrThrow(Biomes.OCEAN)}))))).withPool(LootPool.lootPool().name("swamp").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY_BALL)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LILY_PAD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(1)).setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{registrylookup.getOrThrow(Biomes.SWAMP), registrylookup.getOrThrow(Biomes.MANGROVE_SWAMP)}))))));
    }

    @NotNull
    public static LootPool.Builder createPoolWithItem(Item item, int count) {
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)count)));
    }

    @NotNull
    public static LootPool.Builder createPoolWithItem(Item item, int min, int max) {
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
    }

    @NotNull
    public static LootPool.Builder createPoolWithItem(Item item) {
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item));
    }

    protected LootTable.Builder createCropDrops(Block pCropBlock, Item pGrownCropItem, Item pSeedsItem, LootItemCondition.Builder pDropGrownCropCondition) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)pGrownCropItem).when(pDropGrownCropCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSeedsItem)))).withPool(LootPool.lootPool().when(pDropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pSeedsItem).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3))));
    }
}

