/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.capabilities;

import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class WellFluidCapability
implements IFluidHandler,
IFluidTank {
    private final Fluid fluid;

    public WellFluidCapability(Fluid fluid) {
        this.fluid = fluid;
    }

    @NotNull
    public FluidStack getFluid() {
        return new FluidStack(this.fluid, this.getFluidAmount());
    }

    public int getFluidAmount() {
        return Integer.MAX_VALUE;
    }

    public int getCapacity() {
        return this.getFluidAmount();
    }

    public boolean isFluidValid(FluidStack stack) {
        return stack.getFluid().isSame(this.fluid);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getFluidAmount();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return resource.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return new FluidStack(this.fluid, maxDrain);
    }
}

