/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.sink;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.blocks.sink.SinkCabinetBlockEntity;
import com.lance5057.extradelight.blocks.sink.SinkCabinetMenu;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;

public class SinkCabinetBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public SinkCabinetBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ExtraDelightBlockEntities.SINK_BLOCK.get()).create(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_54041_) {
        Direction direction = p_54041_.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState p_54094_, Rotation p_54095_) {
        return (BlockState)p_54094_.setValue((Property)FACING, (Comparable)p_54095_.rotate((Direction)p_54094_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_54091_, Mirror p_54092_) {
        return p_54091_.rotate(p_54092_.getRotation((Direction)p_54091_.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54097_) {
        p_54097_.add(new Property[]{FACING});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity tileEntity = pLevel.getBlockEntity(pPos);
        if (tileEntity instanceof SinkCabinetBlockEntity) {
            final SinkCabinetBlockEntity be = (SinkCabinetBlockEntity)tileEntity;
            if (!pLevel.isClientSide) {
                if (stack.is(Items.GLASS_BOTTLE)) {
                    BlockEntityUtils.Inventory.givePlayerItemStack(BottleFluidRegistry.getBottleFromFluid(new FluidStack(Fluids.WATER.getSource(), 1000)), pPlayer, pLevel, pPos);
                    pPlayer.getItemInHand(pHand).shrink(1);
                } else if (stack.is(Items.POTION)) {
                    BlockEntityUtils.Inventory.givePlayerItemStack(new ItemStack((ItemLike)Items.GLASS_BOTTLE), pPlayer, pLevel, pPos);
                    pPlayer.getItemInHand(pHand).shrink(1);
                } else {
                    IFluidHandlerItem handlerItem = FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
                    if (handlerItem != null) {
                        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
                        if (f.isEmpty()) {
                            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)be.getFluidHandler(), (int)Integer.MAX_VALUE, (Player)pPlayer, (boolean)true);
                            if (far.isSuccess()) {
                                stack.shrink(1);
                                pPlayer.setItemInHand(pHand, stack);
                                pPlayer.getInventory().placeItemBackInInventory(far.getResult());
                                return ItemInteractionResult.SUCCESS;
                            }
                        } else {
                            FluidActionResult far = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)be.getFluidHandler(), (int)Integer.MAX_VALUE, (Player)pPlayer, (boolean)true);
                            if (far.isSuccess()) {
                                stack.shrink(1);
                                pPlayer.setItemInHand(pHand, stack);
                                pPlayer.getInventory().placeItemBackInInventory(far.getResult());
                                return ItemInteractionResult.SUCCESS;
                            }
                        }
                    } else {
                        MenuProvider containerProvider = new MenuProvider(){

                            public Component getDisplayName() {
                                return Component.translatable((String)be.getDisplayName());
                            }

                            public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                                return new SinkCabinetMenu(windowId, playerInventory, be);
                            }
                        };
                        pPlayer.openMenu(containerProvider, buf -> buf.writeBlockPos(pPos));
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof SinkCabinetBlockEntity) {
                SinkCabinetBlockEntity te = (SinkCabinetBlockEntity)tileEntity;
                IItemHandler items = te.getItemHandler();
                for (int i = 0; i < te.getItemHandler().getSlots(); ++i) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), items.getStackInSlot(i)));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

