/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.picnicbasket;

import com.lance5057.extradelight.ExtraDelightContainers;
import com.lance5057.extradelight.blocks.picnicbasket.PicnicBasketBlock;
import com.lance5057.extradelight.blocks.picnicbasket.PicnicBasketBlockEntity;
import com.lance5057.extradelight.gui.HideableSlot;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PicnicBasketMenu
extends AbstractContainerMenu {
    public final PicnicBasketBlockEntity tileEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;
    private final Player player;

    protected PicnicBasketMenu(int windowId, Inventory playerInventory, PicnicBasketBlockEntity tileEntity) {
        super(ExtraDelightContainers.PICNIC_BASKET_MENU.get(), windowId);
        this.tileEntity = tileEntity;
        this.player = playerInventory.player;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        if (tileEntity != null) {
            int column;
            int startX = 8;
            int startY = 8;
            int inputStartX = 53;
            int inputStartY = 8;
            int borderSlotSize = 18;
            for (int row = 0; row < 3; ++row) {
                for (column = 0; column < 4; ++column) {
                    this.addSlot((Slot)new HideableSlot(this, tileEntity.getItems(), row * 4 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize, true){

                        public boolean mayPlace(ItemStack stack) {
                            Item item = stack.getItem();
                            if (item instanceof BlockItem) {
                                BlockItem bi = (BlockItem)item;
                                if (bi.getBlock() instanceof PicnicBasketBlock) {
                                    return false;
                                }
                                if (bi.getBlock() instanceof ShulkerBoxBlock) {
                                    return false;
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            int startPlayerInvY = startY * 4 + 36;
            for (int row = 0; row < 3; ++row) {
                for (int column2 = 0; column2 < 9; ++column2) {
                    this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
                }
            }
            for (column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 126));
            }
        }
    }

    private static PicnicBasketBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof PicnicBasketBlockEntity) {
            return (PicnicBasketBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public PicnicBasketMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, PicnicBasketMenu.getTileEntity(playerInventory, data));
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        int indexOutput;
        int startPlayerInv = indexOutput = 12;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex < startPlayerInv ? !this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, true) : !this.moveItemStackTo(itemstack1, 0, indexOutput, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player pPlayer) {
        return (Boolean)this.canInteractWithCallable.evaluate((p_38916_, p_38917_) -> !(p_38916_.getBlockState(p_38917_).getBlock() instanceof PicnicBasketBlock) ? false : pPlayer.distanceToSqr((double)p_38917_.getX() + 0.5, (double)p_38917_.getY() + 0.5, (double)p_38917_.getZ() + 0.5) <= 64.0, (Object)true);
    }
}

