/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.jardisplay;

import com.lance5057.extradelight.blocks.IDisplayInteractable;
import com.lance5057.extradelight.blocks.jardisplay.JarDisplayBlockEntity;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.CollisionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JarDisplayBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected VoxelShape SHAPE_NW = Block.box((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)7.0);
    protected VoxelShape SHAPE_NE = Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0);
    protected VoxelShape SHAPE_SW = Block.box((double)1.0, (double)0.0, (double)9.0, (double)7.0, (double)8.0, (double)15.0);
    protected VoxelShape SHAPE_SE = Block.box((double)9.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0);
    protected VoxelShape SOUTH_2 = Shapes.join((VoxelShape)this.SHAPE_SE, (VoxelShape)this.SHAPE_SW, (BooleanOp)BooleanOp.OR);
    protected VoxelShape SOUTH_3 = Shapes.join((VoxelShape)this.SHAPE_NE, (VoxelShape)this.SOUTH_2, (BooleanOp)BooleanOp.OR);
    protected VoxelShape NORTH_2 = Shapes.join((VoxelShape)this.SHAPE_NE, (VoxelShape)this.SHAPE_NW, (BooleanOp)BooleanOp.OR);
    protected VoxelShape NORTH_3 = Shapes.join((VoxelShape)this.SHAPE_SW, (VoxelShape)this.NORTH_2, (BooleanOp)BooleanOp.OR);
    protected VoxelShape WEST_2 = Shapes.join((VoxelShape)this.SHAPE_SW, (VoxelShape)this.SHAPE_NW, (BooleanOp)BooleanOp.OR);
    protected VoxelShape WEST_3 = Shapes.join((VoxelShape)this.SHAPE_SE, (VoxelShape)this.WEST_2, (BooleanOp)BooleanOp.OR);
    protected VoxelShape EAST_2 = Shapes.join((VoxelShape)this.SHAPE_SE, (VoxelShape)this.SHAPE_NE, (BooleanOp)BooleanOp.OR);
    protected VoxelShape EAST_3 = Shapes.join((VoxelShape)this.SHAPE_NW, (VoxelShape)this.EAST_2, (BooleanOp)BooleanOp.OR);
    protected VoxelShape FULL = Shapes.join((VoxelShape)this.SHAPE_NW, (VoxelShape)this.SOUTH_3, (BooleanOp)BooleanOp.OR);

    public JarDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new JarDisplayBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be != null && be instanceof JarDisplayBlockEntity) {
            JarDisplayBlockEntity jdbe = (JarDisplayBlockEntity)be;
            IItemHandler items = jdbe.getItems();
            boolean i1 = !items.getStackInSlot(1).isEmpty();
            boolean i2 = !items.getStackInSlot(2).isEmpty();
            boolean i3 = !items.getStackInSlot(3).isEmpty();
            Direction d = (Direction)pState.getValue((Property)FACING);
            switch (d) {
                case NORTH: {
                    return this.setShape(i1, i2, i3, this.NORTH_2, this.NORTH_3);
                }
                case SOUTH: {
                    return this.setShape(i1, i2, i3, this.SOUTH_2, this.SOUTH_3);
                }
                case WEST: {
                    return this.setShape(i1, i2, i3, this.WEST_2, this.WEST_3);
                }
                case EAST: {
                    return this.setShape(i1, i2, i3, this.EAST_2, this.EAST_3);
                }
            }
        }
        return this.SHAPE;
    }

    private VoxelShape setShape(boolean i1, boolean i2, boolean i3, VoxelShape s2, VoxelShape s3) {
        if (i3) {
            return this.FULL;
        }
        if (i2) {
            return s3;
        }
        return s2;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.isClientSide || stack.isEmpty()) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null || !(be instanceof JarDisplayBlockEntity)) return ItemInteractionResult.SUCCESS;
        JarDisplayBlockEntity jdbe = (JarDisplayBlockEntity)be;
        if (!player.isCrouching()) {
            BlockItem bi;
            Item item = stack.getItem();
            if (!(item instanceof BlockItem) || !((bi = (BlockItem)item) instanceof IDisplayInteractable)) return this.takeServingFromIndividual(player, stack, state, level, (Direction)state.getValue((Property)FACING), result, jdbe.getItems(), pos, hand);
            BlockEntityUtils.Inventory.insertItem(jdbe.getItems(), stack, 4);
            return ItemInteractionResult.SUCCESS;
        } else {
            this.extractItem(level, pos, player, jdbe);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private ItemInteractionResult takeServingFromIndividual(Player player, ItemStack stack, BlockState state, Level level, Direction dir, BlockHitResult result, IItemHandler iItemHandler, BlockPos pos, InteractionHand hand) {
        switch (dir) {
            case WEST: {
                if (CollisionUtil.AABBPointCollision(this.SHAPE_NW.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(1), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_NE.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(3), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_SE.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(2), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_SW.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(0), player, hand, state, pos);
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            case EAST: {
                if (CollisionUtil.AABBPointCollision(this.SHAPE_NW.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(2), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_NE.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(0), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_SE.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(1), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_SW.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(3), player, hand, state, pos);
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            case NORTH: {
                if (CollisionUtil.AABBPointCollision(this.SHAPE_NW.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(0), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_NE.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(1), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_SE.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(3), player, hand, state, pos);
                }
                if (CollisionUtil.AABBPointCollision(this.SHAPE_SW.bounds(), result)) {
                    return this.takeServing(stack, level, iItemHandler.getStackInSlot(2), player, hand, state, pos);
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        if (CollisionUtil.AABBPointCollision(this.SHAPE_NW.bounds(), result)) {
            return this.takeServing(stack, level, iItemHandler.getStackInSlot(3), player, hand, state, pos);
        }
        if (CollisionUtil.AABBPointCollision(this.SHAPE_NE.bounds(), result)) {
            return this.takeServing(stack, level, iItemHandler.getStackInSlot(2), player, hand, state, pos);
        }
        if (CollisionUtil.AABBPointCollision(this.SHAPE_SE.bounds(), result)) {
            return this.takeServing(stack, level, iItemHandler.getStackInSlot(0), player, hand, state, pos);
        }
        if (CollisionUtil.AABBPointCollision(this.SHAPE_SW.bounds(), result)) {
            return this.takeServing(stack, level, iItemHandler.getStackInSlot(1), player, hand, state, pos);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected ItemInteractionResult takeServing(ItemStack stack, Level level, ItemStack individual, Player player, InteractionHand hand, BlockState state, BlockPos pos) {
        BlockItem bi;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (bi = (BlockItem)item) instanceof IDisplayInteractable) {
            IDisplayInteractable b = (IDisplayInteractable)bi;
            return b.itemInteract(stack, individual, state, level, pos, player, hand);
        }
        return ItemInteractionResult.CONSUME;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            if (player.isCrouching() && be != null && be instanceof JarDisplayBlockEntity) {
                JarDisplayBlockEntity jdbe = (JarDisplayBlockEntity)be;
                this.extractItem(level, pos, player, jdbe);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void extractItem(Level level, BlockPos pos, Player player, JarDisplayBlockEntity jdbe) {
        BlockItem bi;
        int i = BlockEntityUtils.Inventory.getLastFilledSlot(jdbe.getItems(), 4);
        ItemStackHandler handler = (ItemStackHandler)jdbe.getItems();
        ItemStack s = jdbe.getItems().getStackInSlot(i);
        Item item = s.getItem();
        if (item instanceof BlockItem && (bi = (BlockItem)item) instanceof IDisplayInteractable) {
            IDisplayInteractable b = (IDisplayInteractable)bi;
            b.extractItem(level, pos, player, jdbe, handler, s, i);
        }
        if (BlockEntityUtils.Inventory.getEmptySlots(jdbe.getItems()) >= 3) {
            this.convertToSingular(pos, level, jdbe);
        }
        level.sendBlockUpdated(pos, jdbe.getBlockState(), jdbe.getBlockState(), 3);
    }

    private void convertToSingular(BlockPos pos, Level level, JarDisplayBlockEntity jdbe) {
        ItemStack stack;
        Item item;
        int i = BlockEntityUtils.Inventory.getLastFilledSlot(jdbe.getItems(), 4);
        if (i != -1 && (item = (stack = jdbe.getItems().getStackInSlot(i).copy()).getItem()) instanceof IDisplayInteractable) {
            IDisplayInteractable bi = (IDisplayInteractable)item;
            bi.convertToSingular(pos, level, jdbe, stack);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            JarDisplayBlockEntity te;
            IItemHandler items;
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof JarDisplayBlockEntity && !(items = (te = (JarDisplayBlockEntity)tileEntity).getItems()).getStackInSlot(1).isEmpty()) {
                for (int i = 0; i < te.getItems().getSlots(); ++i) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), items.getStackInSlot(i)));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

