/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.jar;

import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.blocks.IDisplayInteractable;
import com.lance5057.extradelight.blocks.jar.JarBlockEntity;
import com.lance5057.extradelight.blocks.jardisplay.JarDisplayBlock;
import com.lance5057.extradelight.blocks.jardisplay.JarDisplayBlockEntity;
import com.lance5057.extradelight.modules.Fermentation;
import com.lance5057.extradelight.util.BlockEntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public class JarBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);

    public JarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new JarBlockEntity(p_153215_, p_153216_);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.isClientSide) {
            Item item = stack.getItem();
            if (item instanceof IDisplayInteractable) {
                IDisplayInteractable bi = (IDisplayInteractable)item;
                ItemStack clone = this.getCloneItemStack(state, (HitResult)result, (LevelReader)level, pos, player).copy();
                level.setBlock(pos, (BlockState)((Block)Fermentation.JAR_DISPLAY_BLOCK.get()).defaultBlockState().setValue((Property)JarDisplayBlock.FACING, (Comparable)(result.getDirection() == Direction.UP || result.getDirection() == Direction.DOWN ? player.getDirection() : result.getDirection().getOpposite())), 3);
                BlockEntity be = level.getBlockEntity(pos);
                if (be != null && be instanceof JarDisplayBlockEntity) {
                    JarDisplayBlockEntity jdbe = (JarDisplayBlockEntity)be;
                    BlockEntityUtils.Inventory.insertItem(jdbe.getItems(), clone, 4);
                    BlockEntityUtils.Inventory.insertItem(jdbe.getItems(), stack, 4);
                } else {
                    level.setBlock(pos, state, 3);
                    ExtraDelight.logger.error("Jar Display Entity Invalid!");
                }
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (be != null && be instanceof JarBlockEntity) {
                JarBlockEntity jdbe = (JarBlockEntity)be;
                jdbe.use(player, hand);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity ent = level.getBlockEntity(pos);
        if (ent instanceof JarBlockEntity) {
            JarBlockEntity jbe = (JarBlockEntity)ent;
            stack.set(ExtraDelightComponents.FLUID.get(), (Object)SimpleFluidContent.copyOf((FluidStack)jbe.getTank().getFluid()));
        }
        return stack;
    }
}

