/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.crops;

import com.lance5057.extradelight.ExtraDelightItems;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.registries.DeferredItem;

public class BushStageFour
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<BushStageFour> CODEC = BushStageFour.simpleCodec(BushStageFour::new);
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private final VoxelShape SAPLING_SHAPE;
    private final VoxelShape MID_GROWTH_SHAPE;
    private final DeferredItem<Item> fruit;

    public MapCodec<BushStageFour> codec() {
        return CODEC;
    }

    public BushStageFour(BlockBehaviour.Properties p_57249_) {
        super(p_57249_);
        this.SAPLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
        this.MID_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        this.fruit = ExtraDelightItems.COFFEE_CHERRIES;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BushStageFour(VoxelShape SAPLING_SHAPE, VoxelShape MID_GROWTH_SHAPE, DeferredItem<Item> fruit, BlockBehaviour.Properties properties) {
        super(properties);
        this.SAPLING_SHAPE = SAPLING_SHAPE;
        this.MID_GROWTH_SHAPE = MID_GROWTH_SHAPE;
        this.fruit = fruit;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(LevelReader p_304655_, BlockPos p_57257_, BlockState p_57258_) {
        return new ItemStack((ItemLike)this.fruit.get());
    }

    public VoxelShape getShape(BlockState p_57291_, BlockGetter p_57292_, BlockPos p_57293_, CollisionContext p_57294_) {
        if ((Integer)p_57291_.getValue((Property)AGE) == 0) {
            return this.SAPLING_SHAPE;
        }
        return (Integer)p_57291_.getValue((Property)AGE) < 3 ? this.MID_GROWTH_SHAPE : super.getShape(p_57291_, p_57292_, p_57293_, p_57294_);
    }

    public boolean isRandomlyTicking(BlockState p_57284_) {
        return (Integer)p_57284_.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState p_222563_, ServerLevel p_222564_, BlockPos p_222565_, RandomSource p_222566_) {
        int i = (Integer)p_222563_.getValue((Property)AGE);
        if (i < 3 && p_222564_.getRawBrightness(p_222565_.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_, (p_222566_.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)p_222563_.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            p_222564_.setBlock(p_222565_, blockstate, 2);
            p_222564_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_222565_, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.fireCropGrowPost((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (i > 2) {
            int j = 1 + level.random.nextInt(2);
            BushStageFour.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.fruit.get(), j + 1));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, blockstate, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return ItemInteractionResult.sidedSuccess((!level.isClientSide() ? 1 : 0) != 0);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57282_) {
        p_57282_.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader p_256056_, BlockPos p_57261_, BlockState p_57262_) {
        return (Integer)p_57262_.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level p_222558_, RandomSource p_222559_, BlockPos p_222560_, BlockState p_222561_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_222553_, RandomSource p_222554_, BlockPos p_222555_, BlockState p_222556_) {
        int i = Math.min(3, (Integer)p_222556_.getValue((Property)AGE) + 1);
        p_222553_.setBlock(p_222555_, (BlockState)p_222556_.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

