/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks;

import com.lance5057.extradelight.blocks.RipeSalamiBlock;
import com.lance5057.extradelight.modules.Fermentation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnripeSalamiBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty COUNT = IntegerProperty.create((String)"count", (int)0, (int)3);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    private static final VoxelShape SINGLE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape DOUBLE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape TRIPLE_NS = Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0);
    private static final VoxelShape TRIPLE_EW = Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0);
    private static final VoxelShape QUAD_NS = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape QUAD_EW = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);

    public UnripeSalamiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)COUNT, (Comparable)Integer.valueOf(0))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int count = (Integer)state.getValue((Property)COUNT);
        if (count == 0) {
            return SINGLE;
        }
        if (count == 1) {
            return DOUBLE;
        }
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: 
            case SOUTH: {
                if (count == 2) {
                    return TRIPLE_NS;
                }
                return QUAD_NS;
            }
        }
        if (count == 2) {
            return TRIPLE_EW;
        }
        return QUAD_EW;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COUNT, AGE});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.above()).isSolid();
    }

    public boolean isRandomlyTicking(BlockState p_54449_) {
        return true;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)AGE) < 15) {
            if (random.nextInt() % 10 == 0) {
                int i = (Integer)state.getValue((Property)AGE);
                BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                level.setBlock(pos, blockstate, 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            }
        } else {
            level.setBlock(pos, (BlockState)((BlockState)((Block)Fermentation.SALAMI_BLOCK.get()).defaultBlockState().setValue((Property)RipeSalamiBlock.COUNT, (Comparable)((Integer)state.getValue((Property)COUNT)))).setValue((Property)RipeSalamiBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.isClientSide && stack.is(Fermentation.UNRIPE_SALAMI_ITEM) && (Integer)state.getValue((Property)COUNT) < 3) {
            BlockState s = (BlockState)((BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)COUNT) + 1))).setValue((Property)AGE, (Comparable)Integer.valueOf(0));
            level.setBlock(pos, s, 2);
            player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

