/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class StrippableLog
extends RotatedPillarBlock {
    final RotatedPillarBlock stripped;
    final ResourceKey<LootTable> drop;

    public StrippableLog(RotatedPillarBlock stripped, ResourceKey<LootTable> drop, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.stripped = stripped;
        this.drop = drop;
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility toolAction, boolean simulate) {
        if (ItemAbilities.AXE_STRIP == toolAction && this.stripped != null) {
            this.dropLoot(context.getLevel(), context.getPlayer(), context.getClickedPos());
            return (BlockState)this.stripped.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)));
        }
        return state;
    }

    private void dropLoot(Level level, Player player, BlockPos pos) {
        if (level != null && !level.isClientSide()) {
            LootParams pContext = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player.getLuck() + (float)player.getMainHandItem().getEnchantmentLevel(player.registryAccess().holderOrThrow(Enchantments.FORTUNE))).create(LootContextParamSets.EMPTY);
            player.getServer().reloadableRegistries().getLootTable(this.drop).getRandomItems(pContext).forEach(itemStack -> level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.5f), (double)((float)pos.getZ() + 0.5f), itemStack, 0.0, 0.0, 0.0)));
        }
    }
}

