/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.recipe.FeastRecipe;
import com.lance5057.extradelight.recipe.SimpleRecipeWrapper;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RecipeFeastBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)4);
    public final boolean hasLeftovers;
    protected final VoxelShape[] SHAPES;

    public RecipeFeastBlock(BlockBehaviour.Properties properties, boolean hasLeftovers, VoxelShape ... shapes) {
        super(properties);
        this.SHAPES = shapes;
        this.hasLeftovers = hasLeftovers;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(this.getMaxServings())));
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 4;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.SHAPES.length > 1) {
            return Shapes.joinUnoptimized((VoxelShape)this.SHAPES[0], (VoxelShape)this.rotateShape(state), (BooleanOp)BooleanOp.OR);
        }
        return this.SHAPES[0];
    }

    private VoxelShape rotateShape(BlockState state) {
        if (this.SHAPES.length > 4) {
            boolean l = (Integer)state.getValue((Property)SERVINGS) == 0;
            switch ((Direction)state.getValue((Property)FACING)) {
                case EAST: 
                case WEST: {
                    if (l) {
                        return this.SHAPES[2];
                    }
                    return this.SHAPES[4];
                }
            }
            if (l) {
                return this.SHAPES[1];
            }
            return this.SHAPES[3];
        }
        if (this.SHAPES.length > 2) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case EAST: 
                case WEST: {
                    return this.SHAPES[2];
                }
            }
            return this.SHAPES[1];
        }
        return this.SHAPES[0];
    }

    public Optional<RecipeHolder<FeastRecipe>> matchRecipe(Level level, ItemStack ... itemstack) {
        if (level != null) {
            return level.getServer().getRecipeManager().getRecipeFor(ExtraDelightRecipes.FEAST.get(), (RecipeInput)new SimpleRecipeWrapper(itemstack), level);
        }
        return Optional.empty();
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.takeServing(stack, level, pos, state, player, hand).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        return this.takeServing(stack, level, pos, state, player, hand);
    }

    protected ItemInteractionResult takeServing(ItemStack stack, Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        if (servings == 0) {
            level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.destroyBlock(pos, true);
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack heldStack = player.getItemInHand(hand);
        Optional r = level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.FEAST.get(), (RecipeInput)new SimpleRecipeWrapper(new ItemStack((ItemLike)this.asItem()), stack), level);
        if (r.isPresent()) {
            if (servings > 0) {
                ItemStack result = ((FeastRecipe)((RecipeHolder)r.get()).value()).getResultItem((HolderLookup.Provider)player.level().registryAccess()).copy();
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.getAbilities().instabuild) {
                    if (heldStack.isDamageableItem()) {
                        heldStack.hurtAndBreak(1, (LivingEntity)player, null);
                    } else {
                        heldStack.shrink(1);
                    }
                }
                if (!player.getInventory().add(result)) {
                    player.drop(result, false);
                }
                if ((Integer)level.getBlockState(pos).getValue((Property)this.getServingsProperty()) == 0 && !this.hasLeftovers) {
                    level.removeBlock(pos, false);
                }
                level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"extradelight.block.recipefeast.use_container"), true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SERVINGS});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.getValue((Property)this.getServingsProperty());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MutableComponent textEmpty = Component.translatable((String)"extradelight.tooltip.feast");
        tooltipComponents.add((Component)textEmpty.withStyle(ChatFormatting.BLUE));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)SERVINGS, (Comparable)((Integer)state.getValue((Property)SERVINGS))));
        return stack;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && !player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (Integer)state.getValue((Property)SERVINGS) > 0) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            itemstack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)SERVINGS, (Comparable)((Integer)state.getValue((Property)SERVINGS))));
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

