/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.aesthetics.block.cornhuskdoll;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightWorldGen;
import com.lance5057.extradelight.aesthetics.block.cornhuskdoll.CornHuskDollBlock;
import com.lance5057.extradelight.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CornHuskDollBlockEntity
extends BlockEntity {
    public int maxDistance = 32;
    public int timer = 0;
    public int timerMax = 1000;

    public CornHuskDollBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ExtraDelightBlockEntities.CORN_HUSK_DOLL.get(), pPos, pState);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        if (level.dimension() == ExtraDelightWorldGen.CORNFIELD) {
            CornHuskDollBlockEntity c = (CornHuskDollBlockEntity)be;
            if (c.timer >= c.timerMax) {
                Player closestP = null;
                double closestL = c.maxDistance;
                for (Player p : level.players()) {
                    double d = p.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                    if (!(d < closestL)) continue;
                    closestL = d;
                    closestP = p;
                }
                if (closestP != null) {
                    if (Vec3.atCenterOf((Vec3i)pos).closerThan((Position)closestP.getEyePosition(), 64.0)) {
                        BlockPos pPos = closestP.blockPosition();
                        float angle = (float)Math.atan2(Math.toRadians(pPos.getZ() - pos.getZ()), Math.toRadians(pPos.getX() - pos.getX()));
                        float angle2 = (float)Math.toDegrees(angle) + 180.0f + 90.0f;
                        if (angle2 > 360.0f) {
                            angle2 -= 360.0f;
                        }
                        if (angle2 < 0.0f) {
                            angle2 += 360.0f;
                        }
                        if (angle2 == 360.0f) {
                            angle2 = 0.0f;
                        }
                        int i = MathUtil.getAngleIndex(MathUtil.search(angle2));
                        level.setBlock(pos, (BlockState)state.setValue((Property)CornHuskDollBlock.FACING, (Comparable)Integer.valueOf(i)), 0);
                    }
                    c.timer = 0;
                    c.timerMax = 1000 + level.random.nextInt(1000);
                }
            } else {
                ++c.timer;
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag);
    }

    void readNBT(CompoundTag nbt) {
        this.timer = nbt.getInt("timer");
    }

    CompoundTag writeNBT(CompoundTag tag) {
        tag.putInt("timer", this.timer);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt);
    }
}

