/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.DynamicTimberFrameBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.BlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class DynamicTimberFrameBlockItem
extends BlockItemWithClientBePlacement
implements IDoItem {
    private final DynamicTimberFrameBlock timberFrameBlock;

    public DynamicTimberFrameBlockItem(DynamicTimberFrameBlock blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.timberFrameBlock = blockIn;
    }

    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.timberFrameBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.translatable((String)"domum_ornamentum.dynamic.frame.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.timber.frame.header"));
        IMateriallyTexturedBlockComponent frameComponent = (IMateriallyTexturedBlockComponent)this.timberFrameBlock.getComponents().get(0);
        Block frameBlock = textureData.getTexturedComponents().getOrDefault(frameComponent.getId(), frameComponent.getDefault());
        Component frameBlockName = BlockUtils.getHoverName(frameBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.frame", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{frameBlockName})}));
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.timberFrameBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.center", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{centerBlockName})}));
    }

    @Override
    public List<ResourceLocation> getInputIds() {
        return ImmutableList.of((Object)Constants.resLocDO("frame"), (Object)Constants.resLocDO("center"));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("btimberframe");
    }
}

