/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.baked;

import com.google.common.collect.Maps;
import com.ldtteam.domumornamentum.client.model.utils.ModelSpriteQuadTransformer;
import com.ldtteam.domumornamentum.client.model.utils.ModelSpriteQuadTransformerData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetexturedBakedModelBuilder {
    private static final RandomSource RANDOM = RandomSource.createThreadSafe();
    private final BakedModel sourceModel;
    private final BakedModel target;
    private final RenderType renderType;
    private final BlockState sourceState;
    private final boolean itemStackMode;
    private final Map<ResourceLocation, ReplacementModelData> retexturingMaps = Maps.newHashMap();

    public static RetexturedBakedModelBuilder createFor(BlockState sourceState, RenderType renderType, boolean itemStackMode, BakedModel target) {
        return new RetexturedBakedModelBuilder(target, sourceState, renderType, itemStackMode, target);
    }

    public static RetexturedBakedModelBuilder createFor(BlockState sourceState, RenderType renderType, boolean itemStackMode, BakedModel sourceModel, BakedModel target) {
        return new RetexturedBakedModelBuilder(sourceModel, sourceState, renderType, itemStackMode, target);
    }

    private RetexturedBakedModelBuilder(BakedModel sourceModel, BlockState sourceState, RenderType renderType, boolean itemStackMode, BakedModel target) {
        this.sourceModel = sourceModel;
        this.sourceState = sourceState;
        this.renderType = renderType;
        this.itemStackMode = itemStackMode;
        this.target = target;
    }

    public RetexturedBakedModelBuilder with(ResourceLocation source, BakedModel target, BlockState state) {
        this.retexturingMaps.putIfAbsent(source, new ReplacementModelData(target, state));
        return this;
    }

    public RetexturedBakedModelBuilder with(ResourceLocation source, Block target) {
        BlockState defaultState = target.defaultBlockState();
        BakedModel bakedModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(defaultState);
        if (!this.itemStackMode) {
            if (bakedModel.getRenderTypes(target.defaultBlockState(), RANDOM, ModelData.EMPTY).contains(this.renderType)) {
                return this.with(source, bakedModel, defaultState);
            }
            return this.withOut(source);
        }
        return this.with(source, bakedModel, defaultState);
    }

    public RetexturedBakedModelBuilder withOut(ResourceLocation source) {
        this.retexturingMaps.putIfAbsent(source, null);
        return this;
    }

    public BakedModel build() {
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.sourceModel.useAmbientOcclusion(), this.sourceModel.usesBlockLight(), this.sourceModel.isGui3d(), this.sourceModel.getTransforms(), this.sourceModel.getOverrides());
        this.target.getQuads(null, null, RANDOM, ModelData.EMPTY, this.renderType).forEach(quad -> {
            if (this.needsRetexturing(this.retexturingMaps, quad.getSprite())) {
                this.retexture((BakedQuad)quad, null).ifPresent(arg_0 -> ((SimpleBakedModel.Builder)builder).addUnculledFace(arg_0));
            } else if (!this.needsErasure(this.retexturingMaps, quad.getSprite())) {
                builder.addUnculledFace(quad);
            }
        });
        for (Direction value : Direction.values()) {
            this.target.getQuads(null, value, RANDOM, ModelData.EMPTY, this.renderType).forEach(quad -> {
                if (this.needsRetexturing(this.retexturingMaps, quad.getSprite())) {
                    this.retexture((BakedQuad)quad, value).ifPresent(newQuad -> builder.addCulledFace(value, newQuad));
                } else if (!this.needsErasure(this.retexturingMaps, quad.getSprite())) {
                    builder.addCulledFace(value, quad);
                }
            });
        }
        TextureAtlasSprite particleTexture = this.target.getParticleIcon(ModelData.EMPTY);
        if (this.needsRetexturing(this.retexturingMaps, particleTexture)) {
            BakedModel particleOverrideTextureModel = this.retexturingMaps.get(particleTexture.contents().name()).model();
            particleTexture = particleOverrideTextureModel.getParticleIcon(ModelData.EMPTY);
        }
        builder.particle(particleTexture);
        return builder.build();
    }

    private boolean needsRetexturing(Map<ResourceLocation, ?> retexturingMaps, TextureAtlasSprite quad) {
        return retexturingMaps.containsKey(quad.contents().name()) && retexturingMaps.get(quad.contents().name()) != null;
    }

    private boolean needsErasure(Map<ResourceLocation, ?> retexturingMaps, TextureAtlasSprite quad) {
        return retexturingMaps.containsKey(quad.contents().name()) && retexturingMaps.get(quad.contents().name()) == null;
    }

    private Optional<BakedQuad> retexture(@NotNull BakedQuad quad, @Nullable Direction direction) {
        if (!this.needsRetexturing(this.retexturingMaps, quad.getSprite())) {
            return Optional.empty();
        }
        if (this.needsErasure(this.retexturingMaps, quad.getSprite())) {
            return Optional.empty();
        }
        Optional<ModelSpriteQuadTransformerData> retexturingQuad = this.getRetexturingQuad(quad, direction);
        return retexturingQuad.map(sprite -> {
            IQuadTransformer quadTransformer = ModelSpriteQuadTransformer.create(sprite);
            return quadTransformer.process(quad);
        });
    }

    private Optional<ModelSpriteQuadTransformerData> getRetexturingQuad(@NotNull BakedQuad source, @Nullable Direction direction) {
        if (!this.needsRetexturing(this.retexturingMaps, source.getSprite())) {
            return Optional.empty();
        }
        if (this.needsErasure(this.retexturingMaps, source.getSprite())) {
            return Optional.empty();
        }
        ReplacementModelData modelData = this.retexturingMaps.get(source.getSprite().contents().name());
        List targetQuads = modelData.model().getQuads(null, direction, RANDOM, ModelData.EMPTY, this.renderType);
        if (targetQuads.isEmpty()) {
            targetQuads = modelData.model().getQuads(null, source.getDirection(), RANDOM, ModelData.EMPTY, this.renderType);
        }
        if (targetQuads.isEmpty()) {
            return Optional.empty();
        }
        ModelSpriteQuadTransformerData data = new ModelSpriteQuadTransformerData((BakedQuad)targetQuads.get(0), modelData.state());
        return Optional.of(data);
    }

    record ReplacementModelData(BakedModel model, BlockState state) {
    }
}

