/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemPortalKey
extends BaseItemKey {
    public static final String REG_NAME = "item_portal_key";

    public ItemPortalKey() {
        super(new Item.Properties());
    }

    public static float getKeyLevelAsFloat(ItemStack stack) {
        if (((ItemPortalKey)stack.getItem()).isActivated(stack)) {
            if (((ItemPortalKey)stack.getItem()).getDungeonType(stack) == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                return 0.21f;
            }
            if (((ItemPortalKey)stack.getItem()).getKeyLevel(stack) == 2) {
                return 0.2f;
            }
            return 0.1f;
        }
        return 0.0f;
    }

    public static float getKeyThemeAsFloat(ItemStack stack) {
        int theme = ((ItemPortalKey)stack.getItem()).getDungeonTheme(stack);
        if (((ItemPortalKey)stack.getItem()).getDungeonType(stack) == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
            return 0.999f;
        }
        return (float)theme / 100.0f;
    }

    public boolean isDungeonBuilt(ItemStack stack) {
        if (stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            return ((DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)).built();
        }
        return false;
    }

    public static void setDungeonBuilt(ItemStack stack) {
        if (!stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            DimDungeons.logMessageError("ERROR: setting isBuilt on a non-key or an object without a dungeon key data component.");
            return;
        }
        DungeonKeyDataComponentRecord data = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA);
        DungeonKeyDataComponentRecord newData = new DungeonKeyDataComponentRecord(data.key_activated(), true, data.dest_x(), data.dest_z(), data.name_type(), data.name_part_1(), data.name_part_2(), data.theme(), data.dungeon_type());
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)newData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(ItemStack stack) {
        if (ItemPortalKey.hasLegacyData(stack)) {
            return Component.translatable((String)"item.dimdungeons.item_legacy_key_name");
        }
        if (!stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            return Component.translatable((String)this.getDescriptionId(stack));
        }
        DungeonKeyDataComponentRecord itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA);
        if (itemData.key_activated()) {
            int nameType = itemData.name_type();
            int word_index_1 = itemData.name_part_1();
            int word_index_2 = itemData.name_part_2();
            int theme = itemData.theme();
            Object retval = "";
            if (nameType == 0) {
                String start = I18n.get((String)"npart.dimdungeons.struct_1", (Object[])new Object[0]);
                String preposition = I18n.get((String)"npart.dimdungeons.struct_2", (Object[])new Object[0]);
                String noun1 = I18n.get((String)("npart.dimdungeons.noun_" + word_index_1), (Object[])new Object[0]);
                String noun2 = I18n.get((String)("npart.dimdungeons.noun_" + word_index_2), (Object[])new Object[0]);
                retval = word_index_1 == word_index_2 ? start + " " + noun1 : start + " " + noun1 + " " + preposition + " " + noun2;
            } else if (nameType == 1) {
                String start = I18n.get((String)"npart.dimdungeons.struct_3", (Object[])new Object[0]);
                String preposition = I18n.get((String)"npart.dimdungeons.struct_4", (Object[])new Object[0]);
                String noun1 = I18n.get((String)("npart.dimdungeons.noun_" + word_index_1), (Object[])new Object[0]);
                String noun2 = I18n.get((String)("npart.dimdungeons.noun_" + word_index_2), (Object[])new Object[0]);
                retval = word_index_1 == word_index_2 ? start + " " + noun1 : start + " " + noun1 + " " + preposition + " " + noun2;
            } else if (nameType == 2) {
                String start = I18n.get((String)"npart.dimdungeons.struct_5", (Object[])new Object[0]);
                String preposition = I18n.get((String)"npart.dimdungeons.struct_6", (Object[])new Object[0]);
                String place = I18n.get((String)("npart.dimdungeons.place_" + word_index_1), (Object[])new Object[0]);
                if (theme > 0) {
                    place = I18n.get((String)("npart.dimdungeons.theme_" + theme), (Object[])new Object[0]);
                }
                String noun = I18n.get((String)("npart.dimdungeons.noun_" + word_index_2), (Object[])new Object[0]);
                retval = start + " " + place + " " + preposition + " " + noun;
            } else if (nameType == 3) {
                String start = I18n.get((String)"npart.dimdungeons.struct_7", (Object[])new Object[0]);
                String place = I18n.get((String)("npart.dimdungeons.place_" + word_index_1), (Object[])new Object[0]);
                String largeness = I18n.get((String)("npart.dimdungeons.large_" + word_index_2), (Object[])new Object[0]);
                retval = start + " " + largeness + " " + place;
            } else if (nameType == 4) {
                String start = I18n.get((String)"npart.dimdungeons.struct_9", (Object[])new Object[0]);
                String noun1 = I18n.get((String)("npart.dimdungeons.noun_" + word_index_1), (Object[])new Object[0]);
                retval = start + noun1;
            } else if (nameType == 5) {
                String start = I18n.get((String)("npart.dimdungeons.struct_9_" + word_index_1), (Object[])new Object[0]);
                retval = start;
            }
            return Component.translatable((String)retval);
        }
        return Component.translatable((String)this.getDescriptionId(stack));
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return false;
    }
}

