/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.vanilla;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RedstoneCeilingTorchBlock
extends RedstoneTorchBlock {
    private final Supplier<Block> originalBlock;

    public RedstoneCeilingTorchBlock(BlockBehaviour.Properties properties, Supplier<Block> originalBlock) {
        super(properties.lootFrom(originalBlock));
        this.originalBlock = originalBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CeilingTorchBlock.CEILING_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP && !this.canSurvive(state, (LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return RedstoneCeilingTorchBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public int getSignal(BlockState state, BlockGetter access, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)LIT) != false && Direction.DOWN != side ? 15 : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter access, BlockPos pos, Direction side) {
        return side == Direction.UP ? state.getSignal(access, pos, side) : 0;
    }

    protected boolean hasNeighborSignal(Level world, BlockPos pos, BlockState state) {
        return world.hasSignal(pos.above(), Direction.UP);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double x = (double)pos.getX() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double y = (double)pos.getY() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double z = (double)pos.getZ() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y - 0.25, z, 0.0, 0.0, 0.0);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.originalBlock.get());
    }

    public Block getOriginalBlock() {
        return this.originalBlock.get();
    }
}

