/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.undergarden;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.block.ShardTorchBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGTags;

public class ShardCeilingTorchBlock
extends CeilingTorchBlock {
    public ShardCeilingTorchBlock(BlockBehaviour.Properties properties) {
        super(properties, ParticleTypes.FLAME, (Supplier<? extends Block>)UGBlocks.SHARD_TORCH);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 20);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(4.0), entity -> entity.getType().is(UGTags.Entities.ROTSPAWN)).forEach(entity -> {
            Vec3 center = pos.getCenter();
            if (entity.hurt(UGDamageSources.getShardTorchDamage((Level)level, (Vec3)center), 4.0f)) {
                ShardTorchBlock.drawParticlesTo((ServerLevel)level, (Vec3)center, (Entity)entity);
            }
        });
        level.scheduleTick(pos, (Block)this, 20);
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.45;
        double z = (double)pos.getZ() + 0.5;
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        world.addParticle((ParticleOptions)UGParticleTypes.SHARD.get(), x, y, z, 0.0, 0.0, 0.0);
    }
}

