/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.torchbandolier;

import bl4ckscor3.mod.ceilingtorch.CeilingTorch;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.PlaceHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.silentchaos512.torchbandolier.item.TorchBandolierItem;
import net.silentchaos512.torchbandolier.setup.ModItems;

public class TorchBandolierCompat
implements ICeilingTorchCompat {
    public TorchBandolierCompat() {
        NeoForge.EVENT_BUS.addListener(this::onRightClickBlock);
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getFace() == Direction.DOWN && event.getItemStack().getItem() instanceof TorchBandolierItem) {
            ICeilingTorchCompat compat;
            Map<ResourceLocation, Block> placeEntries;
            String modid;
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            TorchBandolierItem bandolier = (TorchBandolierItem)stack.getItem();
            Block torch = bandolier.getTorchBlock(stack);
            boolean consumeTorch = player != null && !player.isCreative();
            int torchCount = TorchBandolierItem.getTorchCount((ItemStack)stack);
            if (player == null || torch == null || torch instanceof AirBlock || torchCount <= 0 && consumeTorch) {
                return;
            }
            ResourceLocation rl = this.getRegistryName(torch.asItem());
            Map<String, ICeilingTorchCompat> compatList = CeilingTorch.getCompatList();
            if (compatList.containsKey(modid = rl.getNamespace()) && (placeEntries = (compat = compatList.get(modid)).getPlaceEntries()).containsKey(rl) && PlaceHandler.placeTorch(compat, event, ItemStack.EMPTY, event.getPos().relative(event.getFace()), event.getLevel(), placeEntries.get(rl).defaultBlockState())) {
                if (consumeTorch) {
                    TorchBandolierItem.setTorchCount((ItemStack)stack, (int)(--torchCount));
                }
                if (torchCount == 0) {
                    player.getInventory().setItem(player.getInventory().findSlotMatchingItem(stack), new ItemStack((ItemLike)ModItems.EMPTY_TORCH_BANDOLIER.get()));
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        return ImmutableMap.of();
    }
}

