/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.reliquary;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import reliquary.block.InterdictionTorchBlock;
import reliquary.init.ModBlocks;

public class InterdictionCeilingTorchBlock
extends InterdictionTorchBlock {
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CeilingTorchBlock.CEILING_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP && !this.canSurvive(state, (LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return InterdictionCeilingTorchBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.45;
        double z = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.opaque((int)0)), x, y, z, 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModBlocks.INTERDICTION_TORCH.get());
    }
}

