/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.malum;

import bl4ckscor3.mod.ceilingtorch.compat.malum.MalumCompat;
import com.mojang.serialization.DynamicOps;
import com.sammy.malum.common.block.ether.EtherBlockEntity;
import com.sammy.malum.common.item.ether.EtherItem;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public class CeilingEtherTorchBlockEntity
extends EtherBlockEntity {
    public CeilingEtherTorchBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public void tick() {
        ParticleEffectSpawner lightSpecs;
        float velocity;
        float scale;
        int lifeTime;
        ColorParticleData color;
        if (this.firstColor == null) {
            return;
        }
        RandomSource random = this.level.random;
        Color firstColorToUse = new Color(this.firstColor.rgb());
        Color secondColorToUse = new Color(this.secondColor == null ? this.firstColor.rgb() : this.secondColor.rgb());
        double x = (float)this.worldPosition.getX() + 0.5f;
        double y = (float)this.worldPosition.getY() + 0.25f;
        double z = (float)this.worldPosition.getZ() + 0.5f;
        Vec3 sparkPos = new Vec3(x, y, z);
        if (this.level.getGameTime() % 2L == 0L) {
            color = ColorParticleData.create((Color)firstColorToUse, (Color)secondColorToUse).setCoefficient(1.5f).setEasing(Easing.SINE_IN_OUT).build();
            lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.7f, (float)0.9f);
            velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.025f);
            lightSpecs = SpiritLightSpecs.spiritLightSpecs((Level)this.level, (Vec3)sparkPos, (ColorParticleData)color);
            lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setLifetime(lifeTime).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.2f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).addMotion(0.0, (double)(velocity * 1.2f), 0.0);
            lightSpecs.spawnParticlesRaw();
        }
        if (this.level.getGameTime() % 4L == 0L) {
            color = ColorParticleData.create((Color)firstColorToUse, (Color)secondColorToUse).setCoefficient(2.5f).setEasing(Easing.SINE_IN_OUT).build();
            lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.5f);
            velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.025f);
            lightSpecs = SparkParticleEffects.spiritMotionSparks((Level)this.level, (Vec3)sparkPos, (ColorParticleData)color);
            lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setLifetime(lifeTime).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).addMotion(0.0, (double)(velocity * 1.4f), 0.0).setRandomOffset((double)0.1f);
            lightSpecs.spawnParticlesRaw();
        }
        if (this.level.getGameTime() % 16L == 0L) {
            color = ColorParticleData.create((Color)firstColorToUse, (Color)secondColorToUse).setCoefficient(0.6f).setEasing(Easing.SINE_IN_OUT).build();
            lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.9f, (float)1.2f);
            WorldParticleBuilder.create((Supplier)MalumParticles.GIANT_GLOWING_STAR).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build()).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setLifetime(lifeTime).setColorData(color).enableNoClip().spawn(this.level, x, y, z);
        }
        if (this.level.getGameTime() % 4L == 0L) {
            color = ColorParticleData.create((Color)firstColorToUse, (Color)secondColorToUse).setCoefficient(0.6f).setEasing(Easing.SINE_IN_OUT).build();
            lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)20, (int)30);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.25f, (float)0.35f);
            WorldParticleBuilder.create((Supplier)MalumParticles.STAR).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build()).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setLifetime(lifeTime).setColorData(color).enableNoClip().spawn(this.level, x, y, z);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        if (this.getBlockState().is((Block)MalumCompat.IRIDESCENT_ETHER_CEILING_TORCH.get())) {
            this.secondColor = DyedItemColor.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("secondColor")).result().orElse(EtherItem.DEFAULT_SECOND_COLOR);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        if (this.getBlockState().is((Block)MalumCompat.IRIDESCENT_ETHER_CEILING_TORCH.get())) {
            tag.put("secondColor", (Tag)DyedItemColor.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.secondColor).getOrThrow());
        }
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)MalumCompat.ETHER_CEILING_TORCH_BLOCK_ENTITY.get();
    }
}

