/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.hardcoretorches;

import bl4ckscor3.mod.ceilingtorch.compat.hardcoretorches.HardcoreCeilingTorchBlockEntity;
import bl4ckscor3.mod.ceilingtorch.compat.hardcoretorches.HardcoreTorchesCompat;
import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.block.HardcoreFloorTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.TorchBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HardcoreCeilingTorchBlock
extends HardcoreFloorTorchBlock {
    private final Supplier<? extends Block> originalBlock;

    public HardcoreCeilingTorchBlock(BlockBehaviour.Properties properties, SimpleParticleType fireParticle, SimpleParticleType smokeParticle, ETorchState burnState, TorchGroup group, IntSupplier maxFuel, Supplier<? extends Block> originalBlock) {
        super(properties.lootFrom(originalBlock), fireParticle, smokeParticle, burnState, group, maxFuel);
        this.originalBlock = originalBlock;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (((Boolean)Config.fuelMessage.get()).booleanValue() && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TorchBlockEntity) {
            TorchBlockEntity tbe = (TorchBlockEntity)blockEntity;
            player.displayClientMessage((Component)Component.literal((String)("Fuel: " + tbe.getFuel())), true);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CeilingTorchBlock.CEILING_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP && !this.canSurvive(state, (LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return HardcoreCeilingTorchBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.45;
        double z = (double)pos.getZ() + 0.5;
        if (this.fireParticle != null) {
            level.addParticle((ParticleOptions)this.fireParticle, x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.smokeParticle != null) {
            level.addParticle((ParticleOptions)this.smokeParticle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getOriginalBlock());
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING) {
            return type == HardcoreTorchesCompat.CEILING_TORCH_BLOCK_ENTITY.get() ? (l, p, s, be) -> ((TorchBlockEntity)be).tick() : super.getTicker(level, state, type);
        }
        return null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HardcoreCeilingTorchBlockEntity(pos, state);
    }

    public Block getOriginalBlock() {
        return this.originalBlock.get();
    }
}

