/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.chipped;

import bl4ckscor3.mod.ceilingtorch.CeilingTorch;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import bl4ckscor3.mod.ceilingtorch.compat.vanilla.RedstoneCeilingTorchBlock;
import com.google.common.collect.ImmutableMap;
import earth.terrarium.chipped.common.palette.Palettes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ChippedCompat
implements ICeilingTorchCompat {
    public static final List<DeferredBlock<CeilingTorchBlock>> SUPPORTED_TORCHES = new ArrayList<DeferredBlock<CeilingTorchBlock>>();
    public static final List<DeferredBlock<RedstoneCeilingTorchBlock>> SUPPORTED_REDSTONE_TORCHES = new ArrayList<DeferredBlock<RedstoneCeilingTorchBlock>>();
    private Map<ResourceLocation, Block> placeEntries;

    public ChippedCompat() {
        DeferredBlock ceilingBlock;
        DeferredBlock chippedBlock;
        String torchName;
        for (String name : Palettes.TORCH) {
            torchName = name.replace("%", "torch");
            chippedBlock = DeferredBlock.createBlock((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chipped", (String)torchName));
            ceilingBlock = CeilingTorch.BLOCKS.register("chipped_" + torchName, () -> new CeilingTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH), ParticleTypes.FLAME, (Supplier<? extends Block>)chippedBlock));
            SUPPORTED_TORCHES.add((DeferredBlock<CeilingTorchBlock>)ceilingBlock);
        }
        for (String name : Palettes.REDSTONE_TORCH) {
            torchName = name.replace("%", "redstone_torch");
            chippedBlock = DeferredBlock.createBlock((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chipped", (String)torchName));
            ceilingBlock = CeilingTorch.BLOCKS.register("chipped_" + torchName, () -> new RedstoneCeilingTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_TORCH), (Supplier<Block>)chippedBlock));
            SUPPORTED_REDSTONE_TORCHES.add((DeferredBlock<RedstoneCeilingTorchBlock>)ceilingBlock);
        }
    }

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        if (this.placeEntries == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            SUPPORTED_TORCHES.forEach(torch -> builder.put((Object)this.getRegistryName(((CeilingTorchBlock)((Object)((Object)torch.get()))).getOriginalBlock()), (Object)((Block)torch.get())));
            SUPPORTED_REDSTONE_TORCHES.forEach(torch -> builder.put((Object)this.getRegistryName(((RedstoneCeilingTorchBlock)((Object)((Object)torch.get()))).getOriginalBlock()), (Object)((Block)torch.get())));
            this.placeEntries = builder.build();
        }
        return this.placeEntries;
    }
}

