/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.additionallights;

import bl4ckscor3.mod.ceilingtorch.CeilingTorch;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.additionallights.ALCeilingTorchBlock;
import com.google.common.collect.ImmutableMap;
import com.mgen256.al.AdditionalLights;
import com.mgen256.al.FireTypes;
import com.mgen256.al.ModBlockList;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.items.SoulWand;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AdditionalLightsCompat
implements ICeilingTorchCompat {
    private static final HashMap<Supplier<Block>, Supplier<Block>> CEILING_TO_NORMAL;
    private Map<ResourceLocation, Block> placeEntries;

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        if (this.placeEntries == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            CEILING_TO_NORMAL.forEach((ceiling, normal) -> builder.put((Object)this.getRegistryName((Block)normal.get()), (Object)((Block)ceiling.get())));
            this.placeEntries = builder.build();
        }
        return this.placeEntries;
    }

    @Override
    public BlockState getStateToPlace(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        return (BlockState)state.setValue((Property)IHasFire.FIRE_TYPE, (Comparable)(event.getEntity().getOffhandItem().getItem() instanceof SoulWand ? FireTypes.SOUL : FireTypes.NORMAL));
    }

    static {
        ModBlockList[] supportedBlocks;
        CEILING_TO_NORMAL = new HashMap();
        for (ModBlockList block : supportedBlocks = new ModBlockList[]{ModBlockList.ALTorch_Acacia, ModBlockList.ALTorch_Birch, ModBlockList.ALTorch_Oak, ModBlockList.ALTorch_Dark_Oak, ModBlockList.ALTorch_Jungle, ModBlockList.ALTorch_Spruce, ModBlockList.ALTorch_Stone, ModBlockList.ALTorch_CobbleStone, ModBlockList.ALTorch_Mossy_CobbleStone, ModBlockList.ALTorch_End_Stone, ModBlockList.ALTorch_Sand_Stone, ModBlockList.ALTorch_Stone_Bricks, ModBlockList.ALTorch_Mossy_Stone_Bricks, ModBlockList.ALTorch_End_Stone_Bricks, ModBlockList.ALTorch_Nether_Bricks, ModBlockList.ALTorch_Red_Nether_Bricks, ModBlockList.ALTorch_Smooth_Stone, ModBlockList.ALTorch_Glass, ModBlockList.ALTorch_Iron, ModBlockList.ALTorch_Gold, ModBlockList.ALTorch_Diamond, ModBlockList.ALTorch_Ice, ModBlockList.ALTorch_Pink_Wool, ModBlockList.ALTorch_Magenta_Wool, ModBlockList.ALTorch_Crimson, ModBlockList.ALTorch_Warped, ModBlockList.ALTorch_BlackStone}) {
            DeferredHolder originalBlock = (DeferredHolder)AdditionalLights.modBlocks.get(block);
            Object registryName = block.name().toLowerCase(Locale.ENGLISH).replace("altorch", "additional_lights_al_torch");
            if (block == ModBlockList.ALTorch_Oak || block == ModBlockList.ALTorch_Spruce || block == ModBlockList.ALTorch_Birch || block == ModBlockList.ALTorch_Jungle || block == ModBlockList.ALTorch_Acacia || block == ModBlockList.ALTorch_Dark_Oak || block == ModBlockList.ALTorch_Crimson || block == ModBlockList.ALTorch_Warped) {
                registryName = (String)registryName + "_planks";
            }
            DeferredBlock registeredBlock = CeilingTorch.BLOCKS.register((String)registryName, () -> new ALCeilingTorchBlock((Supplier<Block>)originalBlock));
            CEILING_TO_NORMAL.put((Supplier<Block>)registeredBlock, (Supplier<Block>)originalBlock);
        }
    }
}

