/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.additionallights;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import com.mgen256.al.FireTypes;
import com.mgen256.al.blocks.ALTorch;
import com.mgen256.al.blocks.IHasFire;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;

public class ALCeilingTorchBlock
extends CeilingTorchBlock
implements IHasFire {
    public ALCeilingTorchBlock(Supplier<Block> originalBlock) {
        super(BlockBehaviour.Properties.of().noCollission().instabreak(), null, originalBlock);
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.45;
        double z = (double)pos.getZ() + 0.5;
        SimpleParticleType flameParticle = state.getValue((Property)FIRE_TYPE) == FireTypes.SOUL ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)flameParticle, x, y, z, 0.0, 0.0, 0.0);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getOriginalBlock().defaultBlockState().getSoundType();
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getOriginalBlock().getLightEmission(state, level, pos);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return ((ALTorch)this.getOriginalBlock()).getDrops(state, params);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FIRE_TYPE, PREVIOUS_FIRE_TYPE});
    }
}

