/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity.properties;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Random;
import java.util.function.IntFunction;
import net.chococraft.common.entity.breeding.ChocoboAbilityInfo;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public enum ChocoboColor implements StringRepresentable
{
    YELLOW(0, new ChocoboAbilityInfo().setSpeeds(20.0f, 10.0f, 0.0f).setMaxHP(30).setStepHeight(1.0f, 0.5f)),
    GREEN(1, new ChocoboAbilityInfo().setSpeeds(27.0f, 10.0f, 0.0f).setMaxHP(30).setStepHeight(2.0f, 0.5f)),
    BLUE(2, new ChocoboAbilityInfo().setSpeeds(27.0f, 50.0f, 0.0f).setMaxHP(30).setStepHeight(1.0f, 0.5f).setCanWalkOnWater(true).addRiderAbility(() -> new MobEffectInstance(MobEffects.WATER_BREATHING, 100, 0, true, false))),
    WHITE(3, new ChocoboAbilityInfo().setSpeeds(35.0f, 45.0f, 0.0f).setMaxHP(40).setStepHeight(2.0f, 0.5f).setCanClimb(true).setCanWalkOnWater(true)),
    BLACK(4, new ChocoboAbilityInfo().setSpeeds(40.0f, 20.0f, 0.0f).setMaxHP(40).setStepHeight(2.0f, 0.5f).setCanWalkOnWater(true).setCanClimb(true).addRiderAbility(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 200, 0, true, false))),
    GOLD(5, new ChocoboAbilityInfo().setSpeeds(50.0f, 25.0f, 25.0f).setMaxHP(50).setStepHeight(2.0f, 0.5f).setCanWalkOnWater(true).setCanClimb(true).setCanFly(true).setImmuneToFire(true)),
    PINK(6, new ChocoboAbilityInfo().setSpeeds(50.0f, 25.0f, 30.0f).setMaxHP(50).setStepHeight(2.0f, 0.5f).setCanClimb(true).setCanWalkOnWater(true).setCanFly(true)),
    RED(7, new ChocoboAbilityInfo().setSpeeds(50.0f, 25.0f, 35.0f).setMaxHP(50).setStepHeight(2.0f, 0.5f).setCanClimb(true).setCanWalkOnWater(true).setCanFly(true)),
    PURPLE(8, new ChocoboAbilityInfo().setSpeeds(40.0f, 10.0f, 25.0f).setMaxHP(50).setStepHeight(1.0f, 0.5f).setCanClimb(true).setCanFly(true).setImmuneToFire(true).addRiderAbility(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100, -1, true, false))),
    FLAME(9, new ChocoboAbilityInfo().setSpeeds(40.0f, 10.0f, 25.0f).setMaxHP(50).setStepHeight(1.0f, 0.5f).setCanClimb(true).setCanFly(true).setImmuneToFire(true).addRiderAbility(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100, -1, true, false)));

    public static final StringRepresentable.EnumCodec<ChocoboColor> CODEC;
    private static final IntFunction<ChocoboColor> BY_ID;
    public static final StreamCodec<ByteBuf, ChocoboColor> STREAM_CODEC;
    private final int id;
    private final ChocoboAbilityInfo abilityInfo;

    private ChocoboColor(int id, ChocoboAbilityInfo abilityInfo) {
        this.id = id;
        this.abilityInfo = abilityInfo;
    }

    public int getId() {
        return this.id;
    }

    public static ChocoboColor getRandomColor(Random random) {
        return ChocoboColor.values()[random.nextInt(ChocoboColor.values().length)];
    }

    public ChocoboAbilityInfo getAbilityInfo() {
        return this.abilityInfo;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(ChocoboColor::values);
        BY_ID = ByIdMap.continuous(ChocoboColor::getId, (Object[])ChocoboColor.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, ChocoboColor::getId);
    }
}

