/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.mixin.compat.laserio;

import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.util.BaseCardCache;
import com.direwolf20.laserio.util.ItemStackKey;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.createfiltersanywhere.Config;
import xyz.iwolfking.createfiltersanywhere.api.core.CFAFilterSelector;

@Mixin(value={BaseCardCache.class}, remap=false)
public class MixinBaseCardCache {
    @Shadow
    @Final
    public List<ItemStack> filteredItems;
    @Shadow
    @Final
    public ItemStack filterCard;
    @Shadow
    @Final
    public Map<ItemStackKey, Boolean> filterCache;
    @Shadow
    @Final
    public boolean isCompareNBT;
    @Shadow
    @Final
    public boolean isAllowList;

    @Inject(method={"isStackValidForCard(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void checkCreateFilterForCard(ItemStack testStack, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)Config.LASERIO_COMPAT.get()).booleanValue()) {
            return;
        }
        if (this.filterCard.isEmpty()) {
            cir.setReturnValue((Object)true);
        }
        if (!(this.filterCard.getItem() instanceof FilterMod || this.filterCard.getItem() instanceof FilterTag || this.filterCard.getItem() instanceof FilterNBT)) {
            ItemStackKey key = new ItemStackKey(testStack, this.isCompareNBT);
            if (this.filterCache.containsKey(key)) {
                cir.setReturnValue((Object)this.filterCache.get(key));
            }
            for (ItemStack stack : this.filteredItems) {
                if (!CFAFilterSelector.isSupportedFilterStack(stack)) continue;
                if (CFAFilterSelector.doFilterTest(key.getStack(), stack)) {
                    this.filterCache.put(key, this.isAllowList);
                    cir.setReturnValue((Object)this.isAllowList);
                    continue;
                }
                if (!key.equals((Object)new ItemStackKey(stack, this.isCompareNBT))) continue;
                this.filterCache.put(key, this.isAllowList);
                cir.setReturnValue((Object)this.isAllowList);
            }
        }
    }
}

