/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.attributes.impl.apotheosis;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.createfiltersanywhere.api.util.StringUtils;
import xyz.iwolfking.createfiltersanywhere.api.util.apotheosis.ApotheosisUtil;
import xyz.iwolfking.createfiltersanywhere.attributes.impl.apotheosis.ApotheosisAttributes;

public record GemPurityAttribute(Purity purity) implements ItemAttribute
{
    public static final MapCodec<GemPurityAttribute> CODEC = Purity.CODEC.xmap(GemPurityAttribute::new, GemPurityAttribute::purity).fieldOf("value");
    public static final StreamCodec<ByteBuf, GemPurityAttribute> STREAM_CODEC = Purity.STREAM_CODEC.map(GemPurityAttribute::new, GemPurityAttribute::purity);

    public boolean appliesTo(ItemStack itemStack, Level level) {
        Optional<Purity> gemPurity = ApotheosisUtil.getPurityOf(itemStack);
        return gemPurity.isPresent() && gemPurity.get().equals((Object)this.purity);
    }

    public ItemAttributeType getType() {
        return ApotheosisAttributes.APOTH_GEM_PURITY;
    }

    public String getTranslationKey() {
        return "apoth_gem_purity";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{StringUtils.toTitleCase(this.purity.getName())};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new GemPurityAttribute(Purity.NORMAL);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            Optional<Purity> purity = ApotheosisUtil.getPurityOf(stack);
            if (purity != null && purity.isPresent()) {
                list.add(new GemPurityAttribute(purity.get()));
            }
            return list;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

