/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.api.core;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import xyz.iwolfking.createfiltersanywhere.Config;
import xyz.iwolfking.createfiltersanywhere.api.core.CFATests;

public class CFACache {
    public static final ConcurrentHashMap<Integer, CFACache> ITEM_CACHES = new ConcurrentHashMap();
    private static int ticks = 0;
    private final int itemHash;
    private final ConcurrentHashMap<Integer, Boolean> filterMap;
    private int ttk;

    public CFACache(int itemHash) {
        this.itemHash = itemHash;
        this.filterMap = new ConcurrentHashMap();
        this.ttk = (Integer)Config.CACHE_TTK.get();
    }

    public CFACache addFilter(int filterHash, boolean result) {
        this.filterMap.put(filterHash, result);
        this.resetTTK();
        return this;
    }

    public Boolean result(int filterHash) {
        Boolean result = this.filterMap.get(filterHash);
        if (result != null) {
            this.resetTTK();
        }
        return result;
    }

    public void resetTTK() {
        this.ttk = (Integer)Config.CACHE_TTK.get();
    }

    public void tick() {
        if (this.ttk == 0) {
            ITEM_CACHES.remove(this.itemHash);
            return;
        }
        --this.ttk;
    }

    public static boolean getOrCreateFilter(ItemStack stack, Object filterStack, Level level) {
        return CFATests.basicFilterTest(stack, filterStack, level);
    }

    public static void iterateCache() {
        ITEM_CACHES.values().forEach(CFACache::tick);
    }
}

