/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items.packages;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.lopyluna.dndesires.content.items.packages.BurstPackageItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PackageUtils {
    public static ItemStack containingNormal(Level level, List<ItemStack> stacks) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        stacks.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)newInv, (ItemStack)s, (boolean)false));
        return PackageUtils.containingNormal(level, newInv);
    }

    public static ItemStack containingNormal(Level level, ItemStackHandler stacks) {
        ItemStack box = PackageUtils.getRandomNormalBox(level);
        box.set(AllDataComponents.PACKAGE_CONTENTS, (Object)ItemHelper.containerContentsFromHandler((ItemStackHandler)stacks));
        return box;
    }

    public static ItemStack containingBurst(Level level, List<ItemStack> stacks) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        stacks.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)newInv, (ItemStack)s, (boolean)false));
        return PackageUtils.containingBurst(level, newInv);
    }

    public static ItemStack containingBurst(Level level, ItemStackHandler stacks) {
        ItemStack box = PackageUtils.getRandomBurstBox(level);
        box.set(AllDataComponents.PACKAGE_CONTENTS, (Object)ItemHelper.containerContentsFromHandler((ItemStackHandler)stacks));
        return box;
    }

    public static ItemStack containingNormal(RandomSource random, List<ItemStack> stacks) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        stacks.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)newInv, (ItemStack)s, (boolean)false));
        return PackageUtils.containingNormal(random, newInv);
    }

    public static ItemStack containingNormal(RandomSource random, ItemStackHandler stacks) {
        ItemStack box = PackageUtils.getRandomNormalBox(random);
        box.set(AllDataComponents.PACKAGE_CONTENTS, (Object)ItemHelper.containerContentsFromHandler((ItemStackHandler)stacks));
        return box;
    }

    public static ItemStack containingBurst(RandomSource random, List<ItemStack> stacks) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        stacks.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)newInv, (ItemStack)s, (boolean)false));
        return PackageUtils.containingBurst(random, newInv);
    }

    public static ItemStack containingBurst(RandomSource random, ItemStackHandler stacks) {
        ItemStack box = PackageUtils.getRandomBurstBox(random);
        box.set(AllDataComponents.PACKAGE_CONTENTS, (Object)ItemHelper.containerContentsFromHandler((ItemStackHandler)stacks));
        return box;
    }

    public static ItemStack getRandomBurstBox(RandomSource random) {
        ArrayList<BurstPackageItem> rare = new ArrayList<BurstPackageItem>();
        for (Object box : PackageStyles.RARE_BOXES) {
            if (!(box instanceof BurstPackageItem)) continue;
            BurstPackageItem item = (BurstPackageItem)((Object)box);
            rare.add(item);
        }
        ArrayList<BurstPackageItem> standard = new ArrayList<BurstPackageItem>();
        for (PackageItem box : PackageStyles.STANDARD_BOXES) {
            if (!(box instanceof BurstPackageItem)) continue;
            BurstPackageItem item = (BurstPackageItem)box;
            standard.add(item);
        }
        ArrayList<BurstPackageItem> pool = random.nextInt(7500) == 0 ? rare : standard;
        return new ItemStack((ItemLike)pool.get(random.nextInt(pool.size())));
    }

    public static ItemStack getRandomBurstBox(Level level) {
        return PackageUtils.getRandomBurstBox(level.random);
    }

    public static ItemStack getRandomNormalBox(RandomSource random) {
        ArrayList<Object> rare = new ArrayList<Object>();
        for (Object box : PackageStyles.RARE_BOXES) {
            if (box instanceof BurstPackageItem) continue;
            rare.add(box);
        }
        ArrayList<PackageItem> standard = new ArrayList<PackageItem>();
        for (PackageItem box : PackageStyles.STANDARD_BOXES) {
            if (box instanceof BurstPackageItem) continue;
            standard.add(box);
        }
        ArrayList<Object> pool = random.nextInt(7500) == 0 ? rare : standard;
        return new ItemStack((ItemLike)pool.get(random.nextInt(pool.size())));
    }

    public static ItemStack getRandomNormalBox(Level level) {
        return PackageUtils.getRandomNormalBox(level.random);
    }
}

