/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.flywheel.FlywheelBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.StirlingEngineBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.flywheel.PoweredFlywheelBlock;
import dev.lopyluna.dndesires.mixins.FurnaceBlockAccessor;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import dev.lopyluna.dndesires.register.DesiresBlocks;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@EventBusSubscriber
public class StirlingEngineBlock
extends FaceAttachedHorizontalDirectionalBlock
implements IWrenchable,
ProperWaterloggedBlock,
IBE<StirlingEngineBE> {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final MapCodec<StirlingEngineBlock> CODEC = StirlingEngineBlock.simpleCodec(StirlingEngineBlock::new);

    @SubscribeEvent
    public static void usingEngineOnFurnacePreventsGUI(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (blockItem.getBlock() != DesiresBlocks.STIRLING_ENGINE.get()) {
            return;
        }
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (state.getBlock() instanceof AbstractFurnaceBlock) {
            event.setUseBlock(TriState.FALSE);
        }
    }

    public StirlingEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACE, FACING, WATERLOGGED}));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos furnacePos = StirlingEngineBlock.getFurnacePos(state, pos);
        Block block = level.getBlockState(furnacePos).getBlock();
        if (block instanceof AbstractFurnaceBlock) {
            AbstractFurnaceBlock furnaceBlock = (AbstractFurnaceBlock)block;
            ((FurnaceBlockAccessor)furnaceBlock).openContainer$D2D(level, furnacePos, player);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return StirlingEngineBlock.getConnectedDirection(pState).getOpposite() == pDirection && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @NotNull
    protected FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static Direction getFacing(BlockState sideState) {
        return StirlingEngineBlock.getConnectedDirection(sideState);
    }

    public static BlockPos getFlywheelPos(BlockState sideState, BlockPos pos) {
        return pos.relative(StirlingEngineBlock.getConnectedDirection(sideState), 2);
    }

    public static BlockPos getFurnacePos(BlockState sideState, BlockPos pos) {
        return pos.relative(StirlingEngineBlock.getConnectedDirection(sideState), -1);
    }

    protected boolean canSurvive(BlockState pState, LevelReader pReader, BlockPos pPos) {
        return StirlingEngineBlock.canAttach(pReader, pPos, StirlingEngineBlock.getConnectedDirection(pState).getOpposite()) && StirlingEngineBlock.isValidPosition(pReader, pPos.relative(StirlingEngineBlock.getConnectedDirection(pState).getOpposite()), StirlingEngineBlock.getConnectedDirection(pState));
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.relative(pDirection);
        return pReader.getBlockState(blockpos).getBlock() instanceof AbstractFurnaceBlock;
    }

    public static boolean isValidPosition(LevelReader world, BlockPos pos, Direction facing) {
        for (Direction otherFacing : Iterate.directions) {
            BlockPos otherPos;
            BlockState otherState;
            if (otherFacing == facing || !((otherState = world.getBlockState(otherPos = pos.relative(otherFacing))).getBlock() instanceof StirlingEngineBlock)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate = direction.getAxis() == Direction.Axis.Y ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockstate.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }

    @NotNull
    protected static Direction getConnectedDirection(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(stack)) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean isFlywheelValid(BlockState state, BlockState shaft) {
        return (AllBlocks.FLYWHEEL.has(shaft) || DesiresBlocks.POWERED_FLYWHEEL.has(shaft) && ((Direction)shaft.getValue((Property)PoweredFlywheelBlock.FACING)).getAxis() != StirlingEngineBlock.getFacing(state).getAxis()) && shaft.getValue((Property)FlywheelBlock.AXIS) != StirlingEngineBlock.getFacing(state).getAxis();
    }

    @NotNull
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public Class<StirlingEngineBE> getBlockEntityClass() {
        return StirlingEngineBE.class;
    }

    public BlockEntityType<? extends StirlingEngineBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.STIRLING_ENGINE.get();
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.FLYWHEEL).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.getBlock() instanceof StirlingEngineBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            BlockPos flywheelPos = StirlingEngineBlock.getFlywheelPos(state, pos);
            BlockState flywheel = DesiresBlocks.POWERED_FLYWHEEL.getDefaultState();
            for (Direction direct : Direction.orderedByNearest((Entity)player)) {
                if (!direct.getAxis().isVertical() && StirlingEngineBlock.isFlywheelValid(state, flywheel = (BlockState)flywheel.setValue((Property)PoweredFlywheelBlock.FACING, (Comparable)direct))) break;
            }
            BlockState newState = world.getBlockState(flywheelPos);
            if (!newState.canBeReplaced()) {
                return PlacementOffset.fail();
            }
            Direction direction = (Direction)flywheel.getValue((Property)PoweredFlywheelBlock.FACING);
            Direction finalDirection = direction = player.isShiftKeyDown() ? direction.getOpposite() : direction;
            return PlacementOffset.success((Vec3i)flywheelPos, s -> (BlockState)((BlockState)BlockHelper.copyProperties((BlockState)s, (BlockState)DesiresBlocks.POWERED_FLYWHEEL.getDefaultState()).setValue((Property)PoweredFlywheelBlock.FACING, (Comparable)finalDirection)).setValue((Property)PoweredFlywheelBlock.AXIS, (Comparable)finalDirection.getAxis()));
        }
    }
}

