/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.network.room;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.room.upgrade.inventory.RoomUpgradeInventory;
import dev.compactmods.machines.room.ui.upgrades.RoomUpgradeMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record PlayerRequestedUpgradeUIPacket(String roomCode, boolean isIsolated) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerRequestedUpgradeUIPacket> TYPE = new CustomPacketPayload.Type(CompactMachines.modRL((String)"player_wants_to_open_room_upgrade_menu"));
    public static final IPayloadHandler<PlayerRequestedUpgradeUIPacket> HANDLER = (pkt, ctx) -> {
        Player player = ctx.player();
        CompactMachines.room((String)pkt.roomCode()).ifPresent(inst -> player.openMenu(RoomUpgradeMenu.provider(inst), buf -> {
            buf.writeBoolean(pkt.isIsolated);
            buf.writeUtf(pkt.roomCode());
            RoomUpgradeInventory inv = (RoomUpgradeInventory)inst.getData(CMDataAttachments.UPGRADE_ITEMS);
            RoomUpgradeInventory.STREAM_CODEC.encode(buf, (Object)inv);
        }));
    };
    public static final StreamCodec<FriendlyByteBuf, PlayerRequestedUpgradeUIPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerRequestedUpgradeUIPacket::roomCode, (StreamCodec)ByteBufCodecs.BOOL, PlayerRequestedUpgradeUIPacket::isIsolated, PlayerRequestedUpgradeUIPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

