/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.foci;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.items.foci.ElementalFocus;
import alexthw.ars_elemental.registry.ModPotions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import top.theillusivec4.curios.api.SlotContext;

public class GreaterElementalFocus
extends ElementalFocus {
    public GreaterElementalFocus(Item.Properties properties, SpellSchool element) {
        super(properties, element);
    }

    @Override
    public double getDiscount() {
        return (Double)ConfigHandler.COMMON.MajorFocusDiscount.get();
    }

    @Override
    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (this.element.isPartOfSchool(spellPart)) {
            builder.addAmplification(this.getBoostMultiplier() * 2.0);
        }
        return builder;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block20: {
            block19: {
                LivingEntity livingEntity;
                if (slotContext.entity().level().isClientSide() || !((livingEntity = slotContext.entity()) instanceof Player)) break block19;
                player = (Player)livingEntity;
                if (((Boolean)ConfigHandler.COMMON.EnableRegenBonus.get()).booleanValue()) break block20;
            }
            return;
        }
        if (player.tickCount % 20 == 0) {
            HashSet<SpellSchool> foci = new HashSet<SpellSchool>(Set.of(this.getSchool()));
            foci.addAll(this.getSchool().getSubSchools());
            for (SpellSchool school : foci) {
                switch (school.getId()) {
                    case "fire": {
                        if (!player.isOnFire() && !player.isInLava() && !player.hasEffect(ModPotions.MAGIC_FIRE)) break;
                        player.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SPELL_DAMAGE_EFFECT, 200, 1));
                        break;
                    }
                    case "water": {
                        if (!player.isInWaterRainOrBubble()) break;
                        if (player.isSwimming()) {
                            player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 200, 1));
                            player.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.MANA_REGEN_EFFECT, 120, 1));
                            break;
                        }
                        player.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.MANA_REGEN_EFFECT, 120, 0));
                        break;
                    }
                    case "air": {
                        if (player.hasEffect((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SHOCKED_EFFECT)) {
                            player.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.MANA_REGEN_EFFECT, 60, 1));
                            player.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SPELL_DAMAGE_EFFECT, 60, 1));
                            break;
                        }
                        if (!(player.getY() > 200.0)) break;
                        player.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.MANA_REGEN_EFFECT, 120, 0));
                        break;
                    }
                    case "earth": {
                        if (!(player.getY() < 0.0)) break;
                        player.addEffect(new MobEffectInstance((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.MANA_REGEN_EFFECT, 120, 0));
                    }
                }
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation uuid, ItemStack stack) {
        if (this.element.equals(SpellSchools.ELEMENTAL_EARTH) || this.element.getSubSchools().contains(SpellSchools.ELEMENTAL_EARTH)) {
            HashMultimap map = HashMultimap.create();
            map.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(uuid, (double)0.2f, AttributeModifier.Operation.ADD_VALUE));
            return map;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

