/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.network.DischargeEffectPacket;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EffectDischarge
extends ElementalAbstractEffect
implements IDamageEffect,
IPotionEffect {
    public static EffectDischarge INSTANCE = new EffectDischarge();

    public EffectDischarge() {
        super("discharge", "Discharge");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        block8: {
            block7: {
                Entity entity = rayTraceResult.getEntity();
                if (!(entity instanceof LivingEntity)) break block7;
                livingEntity = (LivingEntity)entity;
                if (world instanceof ServerLevel) break block8;
            }
            return;
        }
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        double range = 3.0 + spellStats.getAoeMultiplier();
        DamageSource source = this.buildDamageSource(world, shooter);
        if (livingEntity.hasEffect((Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SHOCKED_EFFECT) || livingEntity.hasEffect(ModPotions.LIGHTNING_LURE)) {
            if (livingEntity.hasEffect(ModPotions.LIGHTNING_LURE)) {
                damage *= 1.3f;
                livingEntity.removeEffect(ModPotions.LIGHTNING_LURE);
            }
            for (ItemStack i : livingEntity.getArmorSlots()) {
                IEnergyStorage energyStorage = (IEnergyStorage)i.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage == null) continue;
                energyStorage.extractEnergy((int)((double)energyStorage.getEnergyStored() * 0.25), false);
                damage *= 1.1f;
            }
            for (LivingEntity entity : world.getEntitiesOfClass(LivingEntity.class, new AABB(livingEntity.blockPosition()).inflate(range), e -> !e.equals((Object)shooter))) {
                if (!this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)entity, source, damage)) continue;
                this.applyConfigPotion(entity, (Holder)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SHOCKED_EFFECT, spellStats);
                DischargeEffectPacket.send(world, new ParticleColor(225, 200, 50), livingEntity.position(), entity.position());
            }
        }
    }

    public void applyPotion(LivingEntity entity, Holder<MobEffect> potionEffect, SpellStats stats, int baseDurationSeconds, int durationBuffSeconds, boolean showParticles) {
        if (entity == null) {
            return;
        }
        int ticks = baseDurationSeconds * 20 + durationBuffSeconds * stats.getDurationInTicks();
        int amp = (int)Math.min(stats.getAmpMultiplier(), 5.0);
        entity.addEffect(new MobEffectInstance(potionEffect, ticks, amp, false, showParticles, true));
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        shooter = !(shooter instanceof Player) ? ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world)) : shooter;
        return DamageUtil.source((LevelAccessor)world, ModRegistry.SPARK, (Entity)shooter);
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 7.0);
        this.addAmpConfig(builder, 3.0);
        this.addPotionConfig(builder, 15);
        this.addExtendTimeConfig(builder, 5);
    }

    public int getDefaultManaCost() {
        return 40;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentRandomize.INSTANCE, AugmentFortune.INSTANCE});
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return Set.of(SpellSchools.ELEMENTAL_AIR);
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 15 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 5 : (Integer)this.EXTEND_TIME.get();
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the range of the discharge shock.");
    }

    public String getBookDescription() {
        return "Discharge an entity affected by static charge or shocked, damaging it and shocking surrounding enemies. If the damage was triggered by static charge, it will be empowered. If the main target had energy-based armors, some of the energy in it will be absorbed to boost damage.";
    }
}

