/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.ai.HijackTurretGoal;
import alexthw.ars_elemental.common.entity.spells.FlashLightning;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.alexthw.sauce.api.item.ISchoolProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.nuggets.client.overlay.IWorldTooltipProvider;
import com.hollingsworth.nuggets.common.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FlashjackEntity
extends Parrot
implements GeoEntity,
ICharmSerializable,
IAnimationListener,
IDispellable,
ISchoolProvider,
IWorldTooltipProvider,
IWandable {
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(FlashjackEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.defineId(FlashjackEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation idle = RawAnimation.begin().thenLoop("idle.air");
    public static final RawAnimation inactive = RawAnimation.begin().thenPlayAndHold("idle.ground");
    public static final RawAnimation flapping = RawAnimation.begin().thenLoop("idle.flapping");
    public static final RawAnimation attack = RawAnimation.begin().thenPlayXTimes("attack", 2).thenWait(40).thenLoop("idle.flapping");
    List<BlockPos> turrets = new ArrayList<BlockPos>();
    List<EntityType<?>> blacklist = new ArrayList();
    AnimationController<FlashjackEntity> actionController;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 36.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    public List<BlockPos> getTurrets() {
        return this.turrets;
    }

    public FlashjackEntity(EntityType<? extends Parrot> entityType, Level level) {
        super(entityType, level);
    }

    public FlashjackEntity(Level world) {
        super((EntityType)ModEntities.FLASHJACK_ENTITY.get(), world);
    }

    List<EntityType<?>> getBlacklist() {
        return this.blacklist;
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    protected int getBaseExperienceReward() {
        return 0;
    }

    public SpellSchool getSchool() {
        return SpellSchools.ELEMENTAL_AIR;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new Parrot.ParrotWanderGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new HijackTurretGoal(this, 30.0f));
        this.goalSelector.addGoal(3, (Goal)new GoBackHomeGoal((Mob)this, this::getHome, 10, () -> this.getTarget() == null));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, entity -> entity instanceof Enemy && entity.isAlive() && !this.getBlacklist().contains(entity.getType())));
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage((DamageSource)pSource) && super.hurt(pSource, pAmount);
    }

    public void tick() {
        super.tick();
        SummonUtil.healOverTime((LivingEntity)this);
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        if (!level.isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack(ModItems.FLASHJACK_CHARM);
            stack.set((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            level.addFreshEntity((Entity)new ItemEntity((Level)level, this.getX(), this.getY(), this.getZ(), stack));
        }
    }

    private static PlayState attackPredicate(AnimationState<FlashjackEntity> event) {
        if (((FlashjackEntity)event.getAnimatable()).onGround()) {
            return PlayState.STOP;
        }
        if (event.isCurrentAnimation(attack)) {
            return PlayState.CONTINUE;
        }
        return event.setAndContinue(flapping);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (!player.level().isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            if (this.isOwnedBy((LivingEntity)player)) {
                if (stack.is(Tags.Items.DYES_YELLOW) && !this.getColor().equals("flashjack")) {
                    this.setColor("flashjack");
                    stack.shrink(1);
                    return InteractionResult.SUCCESS;
                }
                if (stack.is(Tags.Items.DYES_RED) && !this.getColor().equals("flapjack")) {
                    this.setColor("flapjack");
                    stack.shrink(1);
                    return InteractionResult.SUCCESS;
                }
                if (stack.getItem() == ((ArchfruitPod)ModItems.FLASHING_POD.get()).asItem()) {
                    FlashLightning flash = new FlashLightning(this.level);
                    flash.setPos(this.getX(), this.getY(), this.getZ());
                    player.level().addFreshEntity((Entity)flash);
                    Networking.sendToNearbyClient((Level)this.level, (Entity)this, (CustomPacketPayload)new PacketAnimEntity(this.getId(), 0));
                }
            } else if (stack.getItem() == ((ArchfruitPod)ModItems.FLASHING_POD.get()).asItem()) {
                stack.shrink(1);
                this.tame(player);
                FlashLightning flash = new FlashLightning(this.level);
                flash.setPos(this.getX(), this.getY(), this.getZ());
                player.level().addFreshEntity((Entity)flash);
            }
            if (!this.isFlying() && this.isTame() && this.isOwnedBy((LivingEntity)player) && stack.isEmpty()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isTamed() {
        return this.getOwner() != null;
    }

    public static boolean checkSpawnRules(EntityType<? extends Parrot> parrot, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.PARROTS_SPAWNABLE_ON) && FlashjackEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public boolean isActive() {
        return this.getTarget() != null;
    }

    public void thunderHit(@NotNull ServerLevel level, @NotNull LightningBolt lightning) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "idle_controller", 5, event -> this.onGround() ? event.setAndContinue(inactive) : event.setAndContinue(idle)));
        this.actionController = new AnimationController((GeoAnimatable)this, "action_controller", 5, FlashjackEntity::attackPredicate);
        data.add(this.actionController);
    }

    public void startAnimation(int arg) {
        if (arg == 0 && this.actionController != null) {
            this.actionController.setAnimation(attack);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.entityData.get(HOME)).orElse(null);
    }

    public void setHome(BlockPos home) {
        this.entityData.set(HOME, Optional.of(home));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOME, Optional.empty());
        builder.define(COLOR, (Object)"flashjack");
    }

    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack(ModItems.FLASHJACK_CHARM);
            stack.set((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.level), (BlockPos)this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    public void fromCharmData(PersistentFamiliarData data) {
        this.setColor(data.color());
        this.setCustomName(data.name());
    }

    public String getColor() {
        return (String)this.entityData.get(COLOR);
    }

    public void setColor(String color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public ResourceLocation getTexture() {
        return ArsElemental.prefix("textures/entity/" + (this.getColor().isEmpty() ? "flashjack" : this.getColor()) + ".png");
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.getHome() != null) {
            String home = this.getHome().getX() + ", " + this.getHome().getY() + ", " + this.getHome().getZ();
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{home}));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{Component.translatable((String)"ars_nouveau.nothing").getString()}));
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("color", (String)this.entityData.get(COLOR));
        NBTUtil.storeBlockPos((CompoundTag)compound, (String)"home", (BlockPos)this.getHome());
        int counter = 0;
        for (BlockPos blockPos : this.turrets) {
            NBTUtil.storeBlockPos((CompoundTag)compound, (String)("turret_" + counter), (BlockPos)blockPos);
            ++counter;
        }
        counter = 0;
        for (EntityType entityType : this.blacklist) {
            compound.putString("blacklist_" + counter, RegistryHelper.getRegistryName((EntityType)entityType).toString());
            ++counter;
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(COLOR, (Object)compound.getString("color"));
        if (NBTUtil.hasBlockPos((CompoundTag)compound, (String)"home")) {
            this.setHome(NBTUtil.getNullablePos((CompoundTag)compound, (String)"home"));
        }
        this.turrets.clear();
        this.blacklist.clear();
        int counter = 0;
        while (NBTUtil.hasBlockPos((CompoundTag)compound, (String)("turret_" + counter))) {
            BlockPos pos = NBTUtil.getNullablePos((CompoundTag)compound, (String)("turret_" + counter));
            if (pos != null) {
                this.turrets.add(pos);
            }
            ++counter;
        }
        counter = 0;
        while (compound.contains("blacklist_" + counter)) {
            EntityType.byString((String)compound.getString("blacklist_" + counter)).ifPresent(type -> this.blacklist.add((EntityType<?>)type));
            ++counter;
        }
    }

    public IWandable.Result onFirstConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null && playerEntity.level().getBlockEntity(storedPos.pos()) instanceof RotatingTurretTile) {
            this.turrets.add(storedPos.pos());
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"ars_elemental.flashjack.connect"));
        }
        return super.onFirstConnection(storedPos, face, storedEntity, playerEntity);
    }

    public IWandable.Result onLastConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedEntity != null) {
            if (this.blacklist.contains(storedEntity.getType())) {
                this.blacklist.remove(storedEntity.getType());
                playerEntity.sendSystemMessage((Component)Component.translatable((String)"ars_elemental.flashjack.deny.remove"));
            } else {
                this.blacklist.add(storedEntity.getType());
                playerEntity.sendSystemMessage((Component)Component.translatable((String)"ars_elemental.flashjack.deny"));
            }
        } else if (storedPos != null && !(playerEntity.level().getBlockEntity(storedPos.pos()) instanceof RotatingTurretTile)) {
            this.setHome(storedPos.pos());
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.home_set"));
        }
        return super.onLastConnection(storedPos, face, storedEntity, playerEntity);
    }
}

