/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.mundabitur;

import com.stal111.forbidden_arcanus.common.block.clibano.ClibanoCenterBlock;
import com.stal111.forbidden_arcanus.common.block.clibano.ClibanoCornerBlock;
import com.stal111.forbidden_arcanus.common.block.clibano.ClibanoMainPartBlock;
import com.stal111.forbidden_arcanus.common.block.clibano.ClibanoSideBlock;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFrameBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoMainBlockEntity;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.clibano.ClibanoCenterType;
import com.stal111.forbidden_arcanus.common.item.mundabitur.TransformPatternInteraction;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CreateClibanoInteraction
extends TransformPatternInteraction {
    private BlockPos centerPos;

    public CreateClibanoInteraction(Predicate<BlockState> predicate, BlockPattern pattern) {
        super(predicate, pattern);
    }

    @Override
    public void interact(TransformPatternInteraction.TransformPatternContext context) {
        ServerLevel serverLevel;
        Direction[] directionArray;
        Direction clickedFace = context.clickedFace();
        BlockPos pos = context.pos();
        Level level = context.level();
        this.centerPos = pos.relative(clickedFace.getOpposite());
        BlockPos bottomPos = pos.below().relative(clickedFace.getClockWise());
        BlockState cornerState = ((ClibanoCornerBlock)((Object)ModBlocks.CLIBANO_CORNER.get())).defaultBlockState();
        this.placeBlock(level, bottomPos, (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace));
        this.placeBlock(level, bottomPos.relative(clickedFace.getOpposite(), 2), (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace.getClockWise()));
        this.placeBlock(level, bottomPos.relative(clickedFace.getOpposite(), 2).relative(clickedFace.getCounterClockWise(), 2), (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace.getOpposite()));
        this.placeBlock(level, bottomPos.relative(clickedFace.getCounterClockWise(), 2), (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace.getCounterClockWise()));
        BlockPos topPos = pos.above().relative(clickedFace.getClockWise());
        cornerState = (BlockState)cornerState.setValue((Property)BlockStateProperties.BOTTOM, (Comparable)Boolean.valueOf(false));
        this.placeBlock(level, topPos, (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace));
        this.placeBlock(level, topPos.relative(clickedFace.getOpposite(), 2), (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace.getClockWise()));
        this.placeBlock(level, topPos.relative(clickedFace.getOpposite(), 2).relative(clickedFace.getCounterClockWise(), 2), (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace.getOpposite()));
        this.placeBlock(level, topPos.relative(clickedFace.getCounterClockWise(), 2), (BlockState)cornerState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace.getCounterClockWise()));
        BlockState centerState = ((ClibanoCenterBlock)((Object)ModBlocks.CLIBANO_CENTER.get())).defaultBlockState();
        BlockState horizontalSideState = ((ClibanoSideBlock)((Object)ModBlocks.CLIBANO_SIDE_HORIZONTAL.get())).defaultBlockState();
        BlockState verticalSideState = ((ClibanoSideBlock)((Object)ModBlocks.CLIBANO_SIDE_VERTICAL.get())).defaultBlockState();
        for (Direction direction : Direction.values()) {
            BlockPos relativePos = this.centerPos.relative(direction);
            this.placeBlock(level, relativePos, (BlockState)((BlockState)centerState.setValue(ModBlockStateProperties.CLIBANO_CENTER_TYPE, (Comparable)((Object)ClibanoCenterType.getFromDirection(direction, clickedFace)))).setValue((Property)BlockStateProperties.FACING, (Comparable)direction));
            if (direction.getAxis() == Direction.Axis.Y) continue;
            this.placeBlock(level, relativePos.relative(direction.getClockWise()), (BlockState)((BlockState)horizontalSideState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)ModBlockStateProperties.MIRRORED, (Comparable)Boolean.valueOf(direction == clickedFace.getCounterClockWise())));
            this.placeBlock(level, relativePos.relative(Direction.UP), (BlockState)verticalSideState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction));
            this.placeBlock(level, relativePos.relative(Direction.DOWN), (BlockState)((BlockState)verticalSideState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)ModBlockStateProperties.MIRRORED, (Comparable)Boolean.valueOf(true)));
        }
        level.setBlock(this.centerPos, ((ClibanoMainPartBlock)((Object)ModBlocks.CLIBANO_MAIN_PART.get())).defaultBlockState(), 2);
        if (level instanceof ServerLevel && (directionArray = (serverLevel = (ServerLevel)level).getBlockEntity(this.centerPos)) instanceof ClibanoMainBlockEntity) {
            ClibanoMainBlockEntity blockEntity = (ClibanoMainBlockEntity)directionArray;
            blockEntity.setFrontDirection(clickedFace);
            for (Direction direction : Direction.values()) {
                BlockEntity blockEntity2 = serverLevel.getBlockEntity(this.centerPos.relative(direction));
                if (!(blockEntity2 instanceof ClibanoFrameBlockEntity)) continue;
                ClibanoFrameBlockEntity clibanoBlockEntity = (ClibanoFrameBlockEntity)blockEntity2;
                clibanoBlockEntity.setMainDirection(direction.getOpposite());
            }
        }
    }

    @Override
    public void placeBlock(Level level, BlockPos pos, BlockState state) {
        BlockState oldState = level.getBlockState(pos);
        super.placeBlock(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ClibanoFrameBlockEntity) {
            ClibanoFrameBlockEntity blockEntity2 = (ClibanoFrameBlockEntity)blockEntity;
            blockEntity2.setFrameData(new ClibanoFrameBlockEntity.FrameData(oldState, this.centerPos));
        }
    }
}

