/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.item.inventory.IInventorySlot;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public final class RecipeIngredientSourceWrapper {
    public static IRecipeIngredientSource<ItemStack> wrap(final IInventorySlot slot) {
        return new IRecipeIngredientSource<ItemStack>(){

            @Override
            public ItemStack getIngredient() {
                return slot.getStackInSlot();
            }

            @Override
            public ItemStack getMatchFrom(IRecipeIngredient<ItemStack> ingredient) {
                ItemStack current = this.getIngredient();
                if (current.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return ingredient.getMatchFrom(current);
            }

            @Override
            public void consumeIngredient(ItemStack ingredient) {
                if (!ingredient.isEmpty()) {
                    slot.decreaseStackSize(ingredient.getCount(), OperationMode.Execute);
                }
            }

            @Override
            public boolean isEmpty() {
                return slot.isSlotEmpty();
            }
        };
    }

    public static IRecipeIngredientSource<ItemStack> wrap(final IItemHandler inventory, final int slot) {
        return new IRecipeIngredientSource<ItemStack>(){

            @Override
            public ItemStack getIngredient() {
                return inventory.getStackInSlot(slot);
            }

            @Override
            public ItemStack getMatchFrom(IRecipeIngredient<ItemStack> ingredient) {
                ItemStack current = this.getIngredient();
                if (current.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return ingredient.getMatchFrom(current);
            }

            @Override
            public void consumeIngredient(ItemStack ingredient) {
                if (!ingredient.isEmpty()) {
                    inventory.extractItem(slot, ingredient.getCount(), false);
                }
            }

            @Override
            public boolean isEmpty() {
                return this.getIngredient().isEmpty();
            }
        };
    }

    public static IRecipeIngredientSource<FluidStack> wrap(final IFluidHandler handler, final int tank) {
        return new IRecipeIngredientSource<FluidStack>(){

            @Override
            public FluidStack getIngredient() {
                return handler.getFluidInTank(tank);
            }

            @Override
            public FluidStack getMatchFrom(IRecipeIngredient<FluidStack> ingredient) {
                FluidStack current = this.getIngredient();
                if (current.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                return ingredient.getMatchFrom(current);
            }

            @Override
            public void consumeIngredient(FluidStack ingredient) {
                if (!ingredient.isEmpty()) {
                    handler.drain(ingredient, IFluidHandler.FluidAction.EXECUTE);
                }
            }

            @Override
            public boolean isEmpty() {
                return this.getIngredient().isEmpty();
            }
        };
    }

    private RecipeIngredientSourceWrapper() {
    }
}

