/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class ItemStackRecipeIngredient
implements IRecipeIngredient<ItemStack> {
    public static final ModCodecs<ItemStackRecipeIngredient, RegistryFriendlyByteBuf> CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(i -> i._ingredient), (App)Codec.INT.fieldOf("count").forGetter(i -> i._amount)).apply((Applicative)instance, ItemStackRecipeIngredient::new)), StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, i -> i._ingredient, (StreamCodec)ByteBufCodecs.INT, i -> i._amount, ItemStackRecipeIngredient::new));
    private final Ingredient _ingredient;
    private final int _amount;
    private List<ItemStack> _cachedMatchingElements;

    public static ItemStackRecipeIngredient from(Ingredient ingredient) {
        return ItemStackRecipeIngredient.from(ingredient, 1);
    }

    public static ItemStackRecipeIngredient from(Ingredient ingredient, int amount) {
        return new ItemStackRecipeIngredient(ingredient, amount);
    }

    public static ItemStackRecipeIngredient from(ItemStack stack) {
        return ItemStackRecipeIngredient.from(stack, stack.getCount());
    }

    public static ItemStackRecipeIngredient from(ItemStack stack, int amount) {
        return ItemStackRecipeIngredient.from(!stack.getComponents().isEmpty() ? DataComponentIngredient.of((boolean)true, (ItemStack)stack) : Ingredient.of((ItemStack[])new ItemStack[]{stack}), amount);
    }

    public static ItemStackRecipeIngredient from(ItemLike item) {
        return ItemStackRecipeIngredient.from(item, 1);
    }

    public static ItemStackRecipeIngredient from(ItemLike item, int amount) {
        return ItemStackRecipeIngredient.from(Ingredient.of((ItemLike[])new ItemLike[]{item}), amount);
    }

    public static ItemStackRecipeIngredient from(Supplier<? extends ItemLike> item) {
        return ItemStackRecipeIngredient.from((ItemLike)item.get().asItem(), 1);
    }

    public static ItemStackRecipeIngredient from(Supplier<? extends ItemLike> item, int amount) {
        return ItemStackRecipeIngredient.from((ItemLike)item.get().asItem(), amount);
    }

    public static ItemStackRecipeIngredient from(TagKey<Item> tag) {
        return ItemStackRecipeIngredient.from(tag, 1);
    }

    public static ItemStackRecipeIngredient from(TagKey<Item> tag, int amount) {
        return ItemStackRecipeIngredient.from(Ingredient.of(tag), amount);
    }

    @Override
    public boolean isCompatible(ItemStack stack) {
        return this._ingredient.test(stack);
    }

    @Override
    public boolean isCompatible(ItemStack ... ingredients) {
        for (ItemStack stack : ingredients) {
            if (!this._ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getMatchFrom(ItemStack stack) {
        return this.test(stack) ? stack.copyWithCount(this._amount) : ItemStack.EMPTY;
    }

    @Override
    public long getAmount(ItemStack stack) {
        return this.isCompatible(stack) ? (long)this._amount : 0L;
    }

    @Override
    public List<ItemStack> getMatchingElements() {
        if (null == this._cachedMatchingElements) {
            this._cachedMatchingElements = (List)Arrays.stream(this._ingredient.getItems()).filter(stack -> !stack.isEmpty()).map(stack -> stack.getCount() == this._amount ? stack : stack.copyWithCount(this._amount)).collect(ImmutableList.toImmutableList());
        }
        return this._cachedMatchingElements;
    }

    @Override
    public boolean isEmpty() {
        return this._ingredient.isEmpty();
    }

    @Override
    public List<Ingredient> asVanillaIngredients() {
        return ObjectLists.singleton((Object)this._ingredient);
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.isCompatible(stack) && this._amount <= stack.getCount();
    }

    @Override
    public boolean testIgnoreAmount(ItemStack stack) {
        return this.isCompatible(stack);
    }

    public String toString() {
        return this._amount + " " + Arrays.stream(this._ingredient.getItems()).map(stack -> stack.getItem().toString()).collect(Collectors.joining(","));
    }

    protected ItemStackRecipeIngredient(Ingredient ingredient, int amount) {
        this._ingredient = ingredient;
        this._amount = amount;
    }
}

