/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.storage;

import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.world.NeighboringPositions;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

public interface IPartStorage<Controller extends IMultiblockController<Controller>>
extends Iterable<IMultiblockPart<Controller>> {
    public boolean isEmpty();

    public int size();

    public boolean contains(IMultiblockPart<Controller> var1);

    public boolean contains(BlockPos[] var1);

    public boolean contains(long[] var1);

    public boolean contains(NeighboringPositions var1);

    @Nullable
    public IMultiblockPart<Controller> get(BlockPos var1);

    @Nullable
    public IMultiblockPart<Controller> get(long var1);

    public void get(NeighboringPositions var1, List<IMultiblockPart<Controller>> var2);

    @Nullable
    public IMultiblockPart<Controller> getFirst();

    public void addOrReplace(IMultiblockPart<Controller> var1);

    default public void addAll(IPartStorage<Controller> parts) {
        parts.stream().forEach(this::addOrReplace);
    }

    @Nullable
    public void remove(IMultiblockPart<Controller> var1);

    default public void removeAll(Collection<IMultiblockPart<Controller>> parts) {
        parts.forEach(this::remove);
    }

    public void clear();

    public Collection<IMultiblockPart<Controller>> unmodifiable();

    public Stream<IMultiblockPart<Controller>> stream();

    public Stream<IMultiblockPart<Controller>> parallelStream();

    default public void forEach(Consumer<IMultiblockPart<Controller>> consumer, Predicate<IMultiblockPart<Controller>> filter) {
        this.stream().filter(filter).forEach(consumer);
    }

    default public void forEachValidPart(Consumer<IMultiblockPart<Controller>> consumer) {
        this.stream().filter(part -> !part.isPartInvalid()).forEach(consumer);
    }

    default public void forEachNotVisitedPart(Consumer<IMultiblockPart<Controller>> consumer) {
        this.stream().filter(IMultiblockPart::isNotVisited).forEach(consumer);
    }

    public CuboidBoundingBox boundingBox();
}

