/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ContainerDataHandler;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotIndexSet;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotTemplate;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotGeneric;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.Nullable;

public class ModContainer
extends AbstractContainerMenu {
    public static final String INVENTORYNAME_PLAYER_INVENTORY = "playerinventory";
    public static final String INVENTORY_CONTAINER = "container";
    public static final String SLOTGROUPNAME_PLAYER_INVENTORY = "playerinventory_main";
    public static final String SLOTGROUPNAME_PLAYER_HOTBAR = "playerinventory_hotbar";
    private final ContainerFactory _factory;
    private final Map<String, IItemHandler> _registeredInventories;
    private final Map<String, List<Slot>> _inventorySlotsGroups;
    private final Player _player;
    private final ContainerDataHandler _containerDataHandler;
    private final boolean _isClientSide;
    private IEvent<Runnable> _dataUpdateEvent;
    private IConditionallySyncableEntity _syncableEntity;

    public ModContainer(boolean isClientSide, int ticksBetweenUpdates, ContainerFactory factory, MenuType<?> type, int windowId, Inventory playerInventory) {
        super(type, windowId);
        this._factory = factory;
        this._registeredInventories = Maps.newHashMap();
        this._inventorySlotsGroups = Maps.newHashMap();
        this._player = playerInventory.player;
        this._isClientSide = isClientSide;
        this._containerDataHandler = new ContainerDataHandler(this);
    }

    public static ModContainer empty(boolean isClientSide, MenuType<?> type, int windowId, Inventory playerInventory) {
        return new ModContainer(isClientSide, 200, ContainerFactory.EMPTY, (MenuType)type, windowId, playerInventory){

            public void setItem(int slotID, int p_182408_, ItemStack stack) {
            }
        };
    }

    public boolean isClientSide() {
        return this._isClientSide;
    }

    public Optional<IItemHandler> getInventory(String name) {
        return Optional.ofNullable(this._registeredInventories.get(name));
    }

    public void addInventory(String name, IItemHandler inventory) {
        this._registeredInventories.put(name, inventory);
    }

    public void addInventory(String name, Container inventory) {
        this.addInventory(name, (IItemHandler)new InvWrapper(inventory));
    }

    public void addInventory(String name, Inventory inventory) {
        this.addInventory(name, (IItemHandler)new PlayerInvWrapper(inventory));
    }

    public void addBindableData(IBindableData<?> data) {
        Preconditions.checkArgument((boolean)(data instanceof IContainerData), (Object)"Data must implement IContainerData too.");
        this.addContainerData((IContainerData)((Object)data));
    }

    @Deprecated
    public void addContainerData(IContainerData data) {
        this._containerDataHandler.add(data);
    }

    public Runnable subscribeContainerDataUpdate(Runnable handler) {
        if (null == this._dataUpdateEvent) {
            this._dataUpdateEvent = new Event<Runnable>();
        }
        return this._dataUpdateEvent.subscribe(handler);
    }

    public void unsubscribeContainerDataUpdate(Runnable handler) {
        if (null != this._dataUpdateEvent) {
            this._dataUpdateEvent.unsubscribe(handler);
        }
    }

    public void createSlots() {
        for (SlotFactory slotFactory : this._factory.getSlots()) {
            String inventoryName = slotFactory.getInventoryName();
            this.getInventory(inventoryName).ifPresent(inventory -> this.addSlotFor(slotFactory, (IItemHandler)inventory));
        }
    }

    public List<Slot> getInventorySlotsGroup(String inventoryGroupName) {
        if (this._inventorySlotsGroups.containsKey(inventoryGroupName)) {
            return Collections.unmodifiableList(this._inventorySlotsGroups.get(inventoryGroupName));
        }
        return Collections.emptyList();
    }

    public PlayerInventoryUsage getPlayPlayerInventoryUsage() {
        return this._factory.getPlayPlayerInventoryUsage();
    }

    public void syncFrom(@Nullable IConditionallySyncableEntity entity) {
        this._syncableEntity = entity;
    }

    public void onContainerDataSync(CompoundTag data, HolderLookup.Provider registries) {
        if (null != this._syncableEntity && this._syncableEntity.getSyncableEntityId().equals((Object)ResourceLocation.parse((String)data.getString("id")))) {
            this._syncableEntity.syncDataFrom(data.getCompound("payload"), registries, ISyncableEntity.SyncReason.NetworkUpdate);
        }
    }

    public Player getPlayer() {
        return this._player;
    }

    public ContainerDataHandler getContainerDataHandler() {
        return this._containerDataHandler;
    }

    public void onScreenOpened() {
        this.getContainerDataHandler().onScreenOpened();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected boolean moveItemStackTo(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection) {
        Slot targetSlot;
        int targetSlotIndex;
        if (sourceStack.isEmpty() || !this._factory.isIndexValid(startIndex) || !this._factory.isIndexValid(endIndex - 1)) {
            return false;
        }
        int targetSlotIndexModifier = reverseDirection ? -1 : 1;
        int n = targetSlotIndex = reverseDirection ? endIndex - 1 : startIndex;
        if (sourceStack.isStackable()) {
            while (sourceStack.getCount() > 0 && (!reverseDirection && targetSlotIndex < endIndex || reverseDirection && targetSlotIndex >= startIndex)) {
                targetSlot = this.getSlot(targetSlotIndex);
                ItemStack targetItemStack = targetSlot.getItem();
                if (!targetItemStack.isEmpty() && ItemHelper.stackMatch(targetItemStack, sourceStack, ItemHelper.MatchOption.MATCH_EXISTING_STACK) && targetSlot.mayPlace(sourceStack)) {
                    int maxStackSize;
                    int mergedSize = targetItemStack.getCount() + sourceStack.getCount();
                    if (mergedSize <= (maxStackSize = Math.min(targetSlot.getMaxStackSize(), sourceStack.getMaxStackSize()))) {
                        sourceStack.setCount(0);
                        targetItemStack.setCount(mergedSize);
                        targetSlot.setChanged();
                        return true;
                    }
                    if (targetItemStack.getCount() < maxStackSize) {
                        sourceStack.grow(-(maxStackSize - targetItemStack.getCount()));
                        targetItemStack.setCount(maxStackSize);
                        targetSlot.setChanged();
                        return true;
                    }
                }
                targetSlotIndex += targetSlotIndexModifier;
            }
        }
        if (sourceStack.getCount() > 0) {
            int n2 = targetSlotIndex = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && targetSlotIndex < endIndex || reverseDirection && targetSlotIndex >= startIndex) {
                targetSlot = this.getSlot(targetSlotIndex);
                if (!targetSlot.hasItem() && targetSlot.mayPlace(sourceStack)) {
                    targetSlot.set(sourceStack.copy());
                    targetSlot.setChanged();
                    sourceStack.setCount(0);
                    return true;
                }
                targetSlotIndex += targetSlotIndexModifier;
            }
        }
        return false;
    }

    public void clicked(int clickedSlotIndex, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (this._factory.isSlotOfType(clickedSlotIndex, SlotType.GhostInput) && (slot = this.getSlot(clickedSlotIndex)).hasItem()) {
            slot.set(ItemStack.EMPTY);
        }
        SlotType slotType = this._factory.getSlotType(clickedSlotIndex);
        switch (slotType) {
            case GhostOutput: 
            case Static: 
            case Unknown: {
                break;
            }
            default: {
                super.clicked(clickedSlotIndex, dragType, clickTypeIn, player);
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int clickedSlotIndex) {
        Optional<SlotTemplate> clickedTemplate = this._factory.getSlotTemplate(clickedSlotIndex);
        if (clickedTemplate.isEmpty()) {
            Log.LOGGER.warn("Unknown slot clicked in a ModContainer at index " + clickedSlotIndex);
            return ItemStack.EMPTY;
        }
        SlotGeneric clickedSlot = (SlotGeneric)this.getSlot(clickedSlotIndex);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack clickedStack = clickedSlot.getItem();
        ItemStack resultStack = clickedStack.copy();
        switch (clickedTemplate.map(SlotTemplate::getType).orElse(SlotType.Unknown)) {
            case Static: 
            case Input: 
            case Output: {
                if (!(this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, true) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false))) {
                    return ItemStack.EMPTY;
                }
                clickedSlot.onQuickCraft(clickedStack, resultStack);
                break;
            }
            case GhostOutput: 
            case GhostInput: {
                return ItemStack.EMPTY;
            }
            case PlayerInventory: {
                if (this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.Input, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false)) break;
                return ItemStack.EMPTY;
            }
            case PlayerHotbar: {
                if (this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.Input, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, false)) break;
                return ItemStack.EMPTY;
            }
            case Special: {
                if (!this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, true) && !this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false)) {
                    return ItemStack.EMPTY;
                }
                clickedSlot.onQuickCraft(clickedStack, resultStack);
            }
        }
        if (clickedStack.getCount() == 0) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        if (clickedStack.getCount() == resultStack.getCount()) {
            return ItemStack.EMPTY;
        }
        clickedSlot.onTake(player, clickedStack);
        return resultStack;
    }

    protected Slot addSlot(Slot slotIn) {
        if (!(slotIn instanceof SlotGeneric)) {
            throw new RuntimeException("Do not call Container.addSlot() directly! Use the ContainerFactory to add your slots to a ModContainer");
        }
        return super.addSlot(slotIn);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this._player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (null != this._syncableEntity && this._syncableEntity.shouldSyncEntity()) {
                CompoundTag envelope = new CompoundTag();
                envelope.putString("id", this._syncableEntity.getSyncableEntityId().toString());
                envelope.put("payload", (Tag)this._syncableEntity.syncDataTo(new CompoundTag(), (HolderLookup.Provider)player2.registryAccess(), ISyncableEntity.SyncReason.NetworkUpdate));
                Lib.sendServerContainerDataSync(player2, envelope);
            }
            this._containerDataHandler.broadcastChanges(player2);
        }
    }

    private void addSlotFor(SlotFactory slotFactory, IItemHandler inventory) {
        Slot slot = slotFactory.createSlot(inventory);
        super.addSlot(slot);
        this.addSlotToGroup(slotFactory.getInventoryName(), slot);
        switch (slotFactory.getTemplate().getType()) {
            case PlayerInventory: {
                this.addSlotToGroup(SLOTGROUPNAME_PLAYER_INVENTORY, slot);
                break;
            }
            case PlayerHotbar: {
                this.addSlotToGroup(SLOTGROUPNAME_PLAYER_HOTBAR, slot);
            }
        }
    }

    private void addSlotToGroup(String inventoryName, Slot slot) {
        this._inventorySlotsGroups.computeIfAbsent(inventoryName, name -> Lists.newArrayList()).add(slot);
    }

    private boolean addStackToTargetSlots(ItemStack stack, SlotType targetSlotsType, boolean reverseDirection) {
        List<SlotIndexSet> targetIndices = this._factory.getIndicesForType(targetSlotsType);
        if (targetIndices.isEmpty()) {
            return false;
        }
        for (SlotIndexSet indexSet : targetIndices) {
            for (Range<Integer> range : indexSet.asRanges()) {
                if (!this.moveItemStackTo(stack, (Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), reverseDirection)) continue;
                return true;
            }
        }
        return false;
    }
}

