/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.loot;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.ApiStatus;

public class SubProviderBuilder {
    private final ObjectList<LootTableProvider.SubProviderEntry> _entries = new ObjectArrayList(16);
    private final List<LootTableProvider.SubProviderEntry> _immutableEntries = ObjectLists.unmodifiable(this._entries);

    @ApiStatus.Internal
    public List<LootTableProvider.SubProviderEntry> getEntries() {
        return this._immutableEntries;
    }

    public SubProviderBuilder addSubProvider(Function<HolderLookup.Provider, LootTableSubProvider> provider, LootContextParamSet paramSet) {
        Preconditions.checkNotNull(provider, (Object)"Provider must not be null");
        Preconditions.checkNotNull((Object)paramSet, (Object)"Param set must not be null");
        this._entries.add((Object)new LootTableProvider.SubProviderEntry(provider, paramSet));
        return this;
    }

    public SubProviderBuilder addSubProvider(Function<HolderLookup.Provider, LootTableSubProvider> provider) {
        return this.addSubProvider(provider, LootContextParamSets.ALL_PARAMS);
    }

    public SubProviderBuilder addBlockProvider(Function<HolderLookup.Provider, BlockLootSubProvider> blockProvider) {
        Preconditions.checkNotNull(blockProvider, (Object)"Block provider must not be null");
        return this.addSubProvider(blockProvider::apply, LootContextParamSets.BLOCK);
    }

    public SubProviderBuilder addEntityProvider(Function<HolderLookup.Provider, EntityLootSubProvider> entityProvider) {
        Preconditions.checkNotNull(entityProvider, (Object)"Entity provider must not be null");
        return this.addSubProvider(entityProvider::apply, LootContextParamSets.ENTITY);
    }
}

