/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ConditionBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantsList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class MultiPartBuilder
implements BlockStateGenerator {
    private final ModelBuilder _modelBuilder;
    private final Block _block;
    private final List<Part> _parts;

    MultiPartBuilder(ModelBuilder modelBuilder, Block block) {
        Preconditions.checkNotNull((Object)modelBuilder, (Object)"Model builder must not be null");
        Preconditions.checkNotNull((Object)block, (Object)"Block must not be null");
        this._modelBuilder = modelBuilder;
        this._block = block;
        this._parts = new ObjectArrayList(16);
    }

    public MultiPartBuilder part(Variant ... variants) {
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"At least one variant must be provided");
        Part part = new Part();
        part.add(variants);
        this._parts.add(part);
        return this;
    }

    public MultiPartBuilder part(Consumer<@NotNull ModelVariantBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        Part part = new Part();
        ModelVariantBuilder.build(part, this._modelBuilder, builder);
        this._parts.add(part);
        return this;
    }

    public MultiPartBuilder part(Condition condition, Variant ... variants) {
        Preconditions.checkNotNull((Object)condition, (Object)"Condition must not be null");
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"At least one variant must be provided");
        ConditionalPart part = new ConditionalPart(condition);
        part.add(variants);
        this._parts.add(part);
        return this;
    }

    public MultiPartBuilder part(Condition condition, Consumer<@NotNull ModelVariantBuilder> builder) {
        Preconditions.checkNotNull((Object)condition, (Object)"Condition must not be null");
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        ConditionalPart part = new ConditionalPart(condition);
        ModelVariantBuilder.build(part, this._modelBuilder, builder);
        this._parts.add(part);
        return this;
    }

    public MultiPartBuilder part(Consumer<@NotNull ConditionBuilder> builder, Variant ... variants) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"At least one variant must be provided");
        ConditionalPart part = new ConditionalPart(ConditionBuilder.root(builder));
        part.add(variants);
        this._parts.add(part);
        return this;
    }

    public <T extends Comparable<T>> MultiPartBuilder part(Property<T> property, T value, Consumer<@NotNull ModelVariantBuilder> builder) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        ConditionalPart part = new ConditionalPart((Condition)Condition.condition().term(property, value));
        ModelVariantBuilder.build(part, this._modelBuilder, builder);
        this._parts.add(part);
        return this;
    }

    public <T extends Comparable<T>> MultiPartBuilder part(Property<T> property, T value, Variant ... variants) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"At least one variant must be provided");
        ConditionalPart part = new ConditionalPart((Condition)Condition.condition().term(property, value));
        part.add(variants);
        this._parts.add(part);
        return this;
    }

    public MultiPartBuilder part(Consumer<@NotNull ConditionBuilder> conditionBuilder, Consumer<@NotNull ModelVariantBuilder> builder) {
        Preconditions.checkNotNull(conditionBuilder, (Object)"Condition builder must not be null");
        Preconditions.checkNotNull(builder, (Object)"Variant builder must not be null");
        ConditionalPart part = new ConditionalPart(ConditionBuilder.root(conditionBuilder));
        ModelVariantBuilder.build(part, this._modelBuilder, builder);
        this._parts.add(part);
        return this;
    }

    public Block getBlock() {
        return this._block;
    }

    public JsonElement get() {
        StateDefinition stateDefinition = this.getBlock().getStateDefinition();
        this._parts.forEach(part -> part.validate(stateDefinition));
        JsonArray parts = new JsonArray();
        this._parts.stream().map(Part::get).forEach(arg_0 -> ((JsonArray)parts).add(arg_0));
        return (JsonElement)Util.make((Object)new JsonObject(), json -> json.add("multipart", (JsonElement)parts));
    }

    private static class Part
    extends ModelVariantsList
    implements Supplier<JsonElement> {
        public Part() {
            super(16);
        }

        public void validate(StateDefinition<?, ?> states) {
        }

        @Override
        @NotNull
        public JsonElement get() {
            return this.apply("apply", new JsonObject());
        }
    }

    private static class ConditionalPart
    extends Part {
        private final Condition _condition;

        public ConditionalPart(Condition condition) {
            this._condition = condition;
        }

        @Override
        public void validate(StateDefinition<?, ?> states) {
            this._condition.validate(states);
        }

        @Override
        @NotNull
        public JsonObject apply(@NotNull String name, @NotNull JsonObject parent) {
            super.apply(name, parent);
            parent.add("when", (JsonElement)this._condition.get());
            return parent;
        }
    }
}

