/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen;

import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.ProviderSettings;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;

public interface IModDataProvider {
    public void provideData();

    public CompletableFuture<?> processData(CachedOutput var1, HolderLookup.Provider var2);

    public ProviderSettings getSettings();

    default public PackOutput output() {
        return this.getSettings().output();
    }

    default public ResourceLocationBuilder root() {
        return this.getSettings().root();
    }

    default public CompletableFuture<HolderLookup.Provider> lookup() {
        return this.getSettings().registryLookup();
    }

    default public <V> CompletableFuture<V> lookup(Function<HolderLookup.Provider, CompletableFuture<V>> future) {
        return this.lookup().thenCompose(future);
    }

    default public PackOutput.PathProvider createPathProvider(PackOutput.Target target, String kind) {
        return this.output().createPathProvider(target, kind);
    }

    @FunctionalInterface
    public static interface ModFactory<P extends IModDataProvider> {
        public P create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, ResourceLocationBuilder var3);
    }
}

